/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;

/**
 * Represents the <propertyValue> element of the query structure
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IPropertyValue extends IConstraint, IXMLWritable
{
	/**
	 * Answer the namespace for the constraint
	 * 
	 * @return
	 */
	public URI getNamespace();

	/**
	 * Set the namespace for the constraint
	 * 
	 * @param namespace
	 */
	public void setNamespace(URI namespace);

	/**
	 * Answer the local name for the property
	 * 
	 * @return
	 */
	public String getLocalName();

	/**
	 * Set the local name for the property
	 * 
	 * @param localName
	 */
	public void setLocalName(String localName);

	/**
	 * Answer whether the matchAny flag is set to true
	 * 
	 * @return
	 */
	public boolean isMatchAny();

	/**
	 * Set the matchAny flag for the constraint
	 * 
	 * @param matchAny
	 */
	public void setMatchAny(boolean matchAny);

	/**
	 * Set whether the property is in the recordMetadata element of the record
	 * 
	 * @param recordMetadata
	 */
	public void setRecordMetadata(boolean recordMetadata);
	
	/**
	 * Answer whether the property is in the recordMetadata element of the record
	 * 
	 * @return
	 */
	public boolean isRecordMetadata();
	
	/**
	 * Answer the operators being used to compare against property values
	 * 
	 * @return
	 */
	public IOperator[] getOperators();

	/**
	 * Add an operator to the set of operators used to specify matching criteria
	 * 
	 * @param operator
	 */
	public void addOperator(IOperator operator);
}
