/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;

/**
 * Represents a <query> element submitted in XML form to the query service
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IQuery extends IXMLWritable, IRootElement
{
	/**
	 * Add an item template to the query
	 * 
	 * @param itemTemplate
	 */
	public void addItemTemplate(IItemTemplate itemTemplate);
	
	/**
	 * Add a relationship template to the query
	 * 
	 * @param relationshipTemplate
	 */
	public void addRelationshipTemplate(IRelationshipTemplate relationshipTemplate) ;
	
	/**
	 * Retrieve an item template using its id
	 * 
	 * @param id
	 * @return
	 */
	public IItemTemplate getItemTemplate(String id);

	/**
	 * Answer the number of item templates in the receiver
	 * 
	 * @return
	 */
	public int getItemTemplateCount();
	
	/**
	 * Answer an array of item templates defined in the query
	 * 
	 * @return
	 */
	public IItemTemplate[] getItemTemplates();

	/**
	 * Answer the relationship template with the given id
	 * 
	 * @param id
	 * @return
	 */
	public IRelationshipTemplate getRelationshipTemplate(String id);
		
	/**
	 * Answer the number of relationship templates in the receiver
	 * 
	 * @return
	 */
	public int getRelationshipTemplateCount();
	
	/**
	 * Answer an array of relationship templates defined in the query
	 * 
	 * @return
	 */
	public IRelationshipTemplate[] getRelationshipTemplates();
}
