/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;

/**
 * Interface for <nodes> elements in the query service <queryResponse>
 * structure.
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface INodes extends IQueryServiceElementCollection 
{
	/**
	 * Add an Item to the receiver Nodes instance.
	 * Note that the argument will be sent the toItem() method
	 * from the IItemConvertible interfaces.  Implementors of
	 * IItem should just return "this" from the toItem() method.
	 * 
	 * @param itemConvertible
	 */
	public void addItem(IItemConvertible itemConvertible);

	/**
	 * Add an Item to the receiver Nodes instance.
	 *  
	 * @param item The item to be added
	 */
	public void addItem(IItem item);
}
