/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.common;

import java.io.StringWriter;

/**
 * Interface that allows an object to be written out as XML
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IXMLWritable {

	/**
	 * Answer the XML representation of the object, indented by <tt>indentLevel</tt>
	 * tab characters.
	 * 
	 * @param writer
	 * @param indentLevel
	 */
	public void toXML(StringWriter writer, int indentLevel);

}
