/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;

/**
 * Represents the <additionalRecordType> element specified in the CMDBf spec
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IAdditionalRecordType extends IXMLWritable {
	/**
	 * Answer the namespace of the additional record type
	 * 
	 * @return
	 */
	public URI getNamespace();

	/**
	 * Answer the local name of the additional record type
	 * 
	 * @return
	 */
	public String getLocalName();
}
