/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.common;

import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IInstanceResponse;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

/**
 * A relationship notification handler is used to handle the registration
 * or deregistration of a relationship
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface IRelationshipNotificationHandler extends INotificationHandler
{
	/**
	 * Handle the relationship passed in.  The request type will indicate
	 * whether this is a registration or a deregistration request.
	 * 
	 * @param type Indicates the request type.  See 
	 * {@link INotificationHandler#REGISTRATION} and
	 * {@link INotificationHandler#DEREGISTRATION}
	 * @param relationship The relationship to be registered or deregistered
	 * @return An instance response indicating the outcome of handling
	 * this request
	 * 
	 * @throws In case of a fault while handling a relationship
	 */
	public IInstanceResponse handle (int type, IRelationship relationship) throws CMDBfServiceException;
}
