/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.deregistration.service;

import java.io.InputStream;
import java.io.Reader;

import org.eclipse.cosmos.dc.cmdbf.services.cmdbfservice.ICMDBfService;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.service.impl.CMDBfDeregistrationOperation;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterResponse;

/**
 * Represents a CMDBf deregistration operation.  The {@link #execute(InputStream)} method is
 * used to execute a deregistration request that conforms to CMDBf. 
 * 
 * @provisional
 * @see CMDBfDeregistrationOperation
 * @author Ali Mehregani
 */
public interface ICMDBfDeregistrationOperation extends ICMDBfService
{
	/**
	 * Executes the deregistration request and returns the results using a POJO
	 * representation of a CMDBf deregistration response
	 * 
	 * @param deregistration A deregistration request conforming to CMDBf
	 * @return The deregistration response
	 * @throws CMDBfServiceException thrown if the request passed in
	 * is invalid
	 */
	public IDeregisterResponse execute (InputStream deregistration) throws CMDBfServiceException;
	
	
	/**
	 * Executes the deregistration request and returns the results using a POJO
	 * representation of a CMDBf deregistration response
	 * 
	 * @param deregistration A deregistration request conforming to CMDBf
	 * @return The deregistration response
	 * @throws CMDBfServiceException thrown if the request passed in
	 * is invalid
	 */
	public IDeregisterResponse execute (Reader deregistration) throws CMDBfServiceException;
}
