/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.artifacts;

import javax.xml.namespace.QName;

/**
 * Represents an abstract declaration item.  See {@link TypeDeclaration} or
 * {@link GroupDeclaration} for concrete implementations.
 * 
 * @author Ali Mehregani
 */
public abstract class AbstractDeclaration
{
	/**
	 * The qualified name of this declaration
	 */
	private QName qName;

	/**
	 * A reference to a global declaration
	 */
	private QName ref;
	
	/**
	 * The element location
	 */
	private ElementLocation location;
	
	/**
	 * Stores all local element declarations
	 */
	private ElementDeclarationCollection elementDeclarations;
	
	/**
	 * Group declarations associated with this declaration
	 */
	private GroupDeclarationCollection groupDeclarations;
	
	
	public AbstractDeclaration()
	{
		elementDeclarations = new ElementDeclarationCollection();
		groupDeclarations = new GroupDeclarationCollection();
	}
	
	
	/**
	 * @return the qName
	 */
	public QName getQName()
	{
		return qName;
	}

	/**
	 * @param name the qName to set
	 */
	public void setQName(QName name)
	{
		qName = name;
	}	
	
	
	/**
	 * @return the location
	 */
	public ElementLocation getLocation()
	{
		return location;
	}

	/**
	 * @param location the location to set
	 */
	public void setLocation(ElementLocation location)
	{
		this.location = location;
	}
	
	
	/**
	 * @return the localElementDeclarations
	 */
	public ElementDeclarationCollection getElementDeclarations()
	{
		return elementDeclarations;
	}


	/**
	 * @param localElementDeclarations the localElementDeclarations to set
	 */
	public void setElementDeclarations(ElementDeclarationCollection localElementDeclarations)
	{
		this.elementDeclarations = localElementDeclarations;
	}


	/**
	 * @return the groupDeclarations
	 */
	public GroupDeclarationCollection getGroupDeclarations()
	{
		return groupDeclarations;
	}


	/**
	 * @param groupDeclarations the groupDeclarations to set
	 */
	public void setGroupDeclarations(GroupDeclarationCollection groupDeclarations)
	{
		this.groupDeclarations = groupDeclarations;
	}


	/**
	 * @return the ref
	 */
	public QName getRef()
	{
		return ref;
	}


	/**
	 * @param ref the ref to set
	 */
	public void setRef(QName ref)
	{
		this.ref = ref;
	}	
	
}
