/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.artifacts;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

import javax.xml.namespace.QName;

/**
 * An abstract representation of a declaration collection.  See
 * {@link TypeDeclarationCollection} or {@link GroupDeclarationCollectio}
 * for concrete implementations.
 * 
 * @author Ali Mehregani
 */
public abstract class AbstractDeclarationCollection<T> extends ArrayList<T>
{
	/**
	 * Serial version UID
	 */
	private static final long serialVersionUID = 5392889191351236628L;
	
	
	/**
	 * Indexes declarations by namespace and local name
	 */
	private Map<QName, T> uriNameIndex;
	
	
	public AbstractDeclarationCollection()
	{
		uriNameIndex = new Hashtable<QName, T>();
	}
	
	
	/**
	 * @see java.util.ArrayList#add(java.lang.Object)
	 */
	@Override
	public boolean add(T o)
	{
		QName qName = ((AbstractDeclaration)o).getQName();
		if (qName != null)
		{			
			uriNameIndex.put(qName, o);
		}
		return super.add(o);
	}
	
	
	/**
	 * Returns a type declaration based on the uri and local name of the
	 * qualified name passed in
	 * s
	 * @param name The qualified name
	 * @return An associated type declaration
	 */	
	public T get(QName name)
	{	
		return uriNameIndex.get(name);
	}
}
