/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.artifacts;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderUtil;

public class ElementDeclarationCollection extends ArrayList<ConstraintNode>
{
	/**
	 * Serial version UID
	 */
	private static final long serialVersionUID = 3065372992318203085L;

	
	/**
	 * Elements indexed by namespace URI and local name
	 */
	private Map<String, Map<String, ConstraintNode>> uriNameIndex;
	
	
	public ElementDeclarationCollection()
	{
		uriNameIndex = new Hashtable<String, Map<String, ConstraintNode>>();
	}
	
	
	/**
	 * Retrieve an element declaration based on a qualified name
	 * 
	 * @param qName The qualified name 
	 * @return The associated element declaration
	 */
	@SuppressWarnings("unchecked")
	public ConstraintNode get(QName qName)
	{
		Map<String, ConstraintNode> nestedMap = (Map<String, ConstraintNode>)SMLValidatorUtil.retrieveNestedMap(uriNameIndex, qName.getNamespaceURI(), false);
		ConstraintNode targetSchemaNode = nestedMap == null ? null : nestedMap.get(qName.getLocalPart());
		if (targetSchemaNode == null)
		{
			return null;
		}
		
		
		// Resolve the node if it's a reference
		if (targetSchemaNode != null && targetSchemaNode.getName() == null && targetSchemaNode.getRef() != null)
		{
			return DataBuilderUtil.retrieveElement(targetSchemaNode.getRef());
		}
		
		return targetSchemaNode;		
	}
	
	
	/**
	 * @see java.util.ArrayList#add(java.lang.Object)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public boolean add(ConstraintNode localElementDeclaration)
	{
		QName ref = localElementDeclaration.getRef();
		boolean isReference = ref != null;
		String uri = isReference ? ref.getNamespaceURI() : localElementDeclaration.getUri();
		String localName = isReference ? ref.getLocalPart() : localElementDeclaration.getName();		
		
		if (uri != null && localName != null)
		{
			Map<String, ConstraintNode> nestedMap = (Map<String, ConstraintNode>)SMLValidatorUtil.retrieveNestedMap(uriNameIndex, uri, true);
			nestedMap.put(localName, localElementDeclaration);
		}
		
		return super.add(localElementDeclaration);
	}
}
