/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.artifacts;

import java.util.ArrayList;
import java.util.List;

/**
 * A data structure that stores the schema rule bindings
 * It corresponds to a schemaBinding element who has one
 * namespaceBinding element and one or more documentAlias elements
 * using the namespace defined in the namespaceBinding.
 * 
 * @author popescu
 */
public class SchemaBindingStructure
{
	private int lineNumber;
	private String filePath;
	
	/**
	 * target namespace for bound document schemas
	 */
	private String namespace;
	/**
	 * list of document aliases that define the namespace
	 */
	private List<String> schemaDocAliases;
	/**
	 * list of instance documents using these schemas 
	 */
	private List<String> instanceDocAliases;
	
	/**
	 * true if this schema binding corresponds to the defaultSchema element
	 */
	private boolean isDefaultSchema;		

	
	public SchemaBindingStructure()
	{
		schemaDocAliases = new ArrayList<String>();
		instanceDocAliases = new ArrayList<String>();
		isDefaultSchema = false;
		
	}
	
	
	/**
	 * @return the namespace
	 */
	public String getNamespace() {
		return namespace;
	}


	/**
	 * @param namespace the namespace to set
	 */
	public void setNamespace(String namespace) {
		this.namespace = namespace;
	}


	/**
	 * @return the schemaDocAliases
	 */
	public List<String> getSchemaDocAliases() {
		return schemaDocAliases;
	}


	/**
	 * @param schemaDocAliases the schemaDocAliases to set
	 */
	public void setSchemaDocAliases(List<String> schemaDocAliases) {
		this.schemaDocAliases = schemaDocAliases;
	}
	
	/**
	 * 
	 * @param schemaDocAlias
	 */
	public void addSchemaDocAlias(String schemaDocAlias)
	{
		if(schemaDocAlias != null)
			schemaDocAliases.add(schemaDocAlias);
	}
	
	/**
	 * 
	 * @param instanceDocAlias
	 */
	public void addInstanceDocAlias(String instanceDocAlias)
	{
		if(instanceDocAlias != null)
			instanceDocAliases.add(instanceDocAlias);
	}


	/**
	 * @return the instanceDocAliases
	 */
	public List<String> getInstanceDocAliases() {
		return instanceDocAliases;
	}


	/**
	 * @param instanceDocAliases the instanceDocAliases to set
	 */
	public void setInstanceDocAliases(List<String> instanceDocAliases) {
		this.instanceDocAliases = instanceDocAliases;
	}


	/**
	 * @return the isDefaultSchema
	 */
	public boolean isDefaultSchema() {
		return isDefaultSchema;
	}


	/**
	 * @param isDefaultSchema the isDefaultSchema to set
	 */
	public void setDefaultSchema(boolean isDefaultSchema) {
		this.isDefaultSchema = isDefaultSchema;
	}


	/**
	 * @return the lineNumber
	 */
	public int getLineNumber() {
		return lineNumber;
	}


	/**
	 * @return the filePath
	 */
	public String getFilePath() {
		return filePath;
	}


	/**
	 * @param lineNumber the lineNumber to set
	 */
	public void setLineNumber(int lineNumber) {
		this.lineNumber = lineNumber;
	}


	/**
	 * @param filePath the filePath to set
	 */
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}
	
}
