/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.artifacts;

/**
 * TargetElementNode models an instance element with a targetElement attribute
 * @author sleeloy
 *
 */
public class TargetElementNode extends ElementNode {
	
	/**
	 * the uri is an element instance
	 */
	public static final byte INSTANCE_TYPE = 0x01;
	/**
	 * the uri is a type instance
	 */
	public static final byte TYPE_TYPE = 0x11;
	
	protected boolean required;
	protected String targetURI;
	protected byte targetURIType = INSTANCE_TYPE;
	
	public TargetElementNode() {
		super();
	}

	public TargetElementNode(String name, String filePath, int line, int column) {
		super(name, filePath, line, column);
	}

	public String getTargetURI() {
		return targetURI;
	}

	public void setTargetURI(String uri) {
		this.targetURI = uri;
	}

	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}

	public byte getTargetURIType() {
		return targetURIType;
	}

	public void setTargetURIType(byte uriType) {
		this.targetURIType = uriType;
	}
	
}
