/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.common;


/**
 * A validation message stores the fields of a message in the form
 * of attributes.  See the ATTRIBUTE_* constants for more details.
 * 
 * @author Ali Mehregani
 */
public interface IValidationMessage
{
	/**
	 * Indicates a severity of info
	 */
	public static final int SEVERITY_INFO = 0;
	
	/**
	 * Indicates a severity of warning
	 */
	public static final int SEVERITY_WARNING = 1;
	
	/**
	 * Indicates a severity of error
	 */
	public static final int SEVERITY_ERROR = 2;
	
	/**
	 * The message attribute.  The value of this attribue is expected
	 * to be a {@link String}
	 */
	public static final String ATTRIBUTE_MESSAGE = "attribute.message";
	
	/**
	 * The severity attribute.  The value of this attribute is expected
	 * to be one of: <br/>
	 * SEVERITY_INFO <br/>
	 * SEVERITY_WARNING <br/>
	 * SEVERITY_ERROR <br/>
	 */
	public static final String ATTRIBUTE_SEVERITY = "attribute.severity";
	
	/**
	 * An object of type IResource indicating the resource associated with this message
	 */
	public static final String ATTRIBUTE_RESOURCE = "attribute.resource";
	
	/**
	 * An integer indicating the line number associated with this message
	 */
	public static final String ATTRIBUTE_LINE_NUMBER = "attribute.line.number";

	/**
	 * An integer indicating the character location associated with this message
	 */
	public static final String ATTRIBUTE_COLUMN_NUMBER = "attribute.column.number";
	
			
	/**
	 * Set a string attribute
	 * 
	 * @param key The key 
	 * @param value The value
	 */
	public void setAttribute(String key, String value);
	
	
	/**
	 * Set an integer attribute
	 * 
	 * @param key The key 
	 * @param value The value
	 */
	public void setAttribute(String key, int value);	
	
	
	/**
	 * Set a boolean attribute
	 * 
	 * @param key The key 
	 * @param value The value
	 */
	public void setAttribute(String key, boolean value);
	
	
	/**
	 * Set an object attribute
	 * 
	 * @param key The key 
	 * @param value The value
	 */
	public void setAttribute(String key, Object value);
	
	
	/**
	 * Retrieve an integer attribute
	 * 
	 * @param key The key 
	 * @param defaultValue The default value
	 */
	public int getAttribute(String key, int defaultValue);
	
	
	/**
	 * Retrieve a boolean attribute
	 * 
	 * @param key The key 
	 * @param defaultValue The default value
	 */
	public boolean getAttribute(String key, boolean defaultValue);
			
	
	/**
	 * Retrieve a string attribute
	 * 
	 * @param key The key 
	 * @param defaultValue The default value
	 */
	public String getAttribute(String key, String defaultValue);
	
	
	/**
	 * Retrieve an object attribute
	 * 
	 * @param key The key 
	 */
	public Object getAttribute(String key);
}
