/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.common;

import java.util.Map;

/**
 * Represents a validation output.
 * 
 * @author Ali Mehregani
 */
public interface IValidationOutput<K,V>
{
	/**
	 * Used to initialize this validation output
	 * 
	 * @param attributes Attributes describing the setting
	 */
	public void initialize(Map<K,V> attributes);
	
	
	/**
	 * A message is reported with a set of attributes that determine
	 * how the message should be logged.  VerificationMessage.ATTRIBUTE_* constants 
	 * are valid attribute keys.
	 * 
	 * @param attributes The attributes of the message to be reported
	 */
	public void reportMessage(IValidationMessage validationMessage);
	
	
	/**
	 * Closes any stream and performs any clean up necessary
	 */
	public void close();
}
