/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.common;

import java.util.Iterator;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * A node iterator is used to traverse through a set of child nodes 
 * with a specific name
 * 
 * @author Ali Mehregani
 */
public class NodeIterator implements Iterator<Node>
{
	/**
	 * The children of the parent node
	 */
	private NodeList children;
	
	/**
	 * The current child index
	 */
	private int index;
	
	/**
	 * The next item in the list
	 */
	private Node next;

	/**
	 * The name space URI
	 */
	private String uri;

	/**
	 * The local name
	 */
	private String localName;
	
	
	/**
	 * The constructor 
	 * 
	 * @param parent The parent node
	 * @param uri The name space URI
	 * @param localName The local name
	 */
	public NodeIterator(Node parent, String uri, String localName)
	{
		this.children = parent.getChildNodes();
		this.index = 0;
		this.uri = uri;
		this.localName = localName;
	}
	
	/**
	 * @see java.util.Iterator#hasNext()
	 */
	public boolean hasNext()
	{
		if (index == 0 && next == null)
		{
			findNextItem();
		}
		
		return next != null;
	}

	private void findNextItem()
	{		
		for (int childrenCount = children.getLength(); index < childrenCount; index++)
		{
			Node currentNode = children.item(index);
			if ((uri == null || uri.equals(currentNode.getNamespaceURI())) &&
				localName.equals(currentNode.getLocalName()))
			{
				next = currentNode;
				index++;
				return;
			}
		}
		
		next = null;
	}

	/**
	 * @see java.util.Iterator#next()
	 */
	public Node next()
	{
		if (index == 0 && next == null)
		{
			findNextItem();
		}
		
		Node tmp = next;
		findNextItem();
		return tmp;
	}

	/** 
	 * @see java.util.Iterator#remove()
	 */
	public void remove()
	{
		/* purposely not implemented */
	}	
}
