/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.core;

import org.xml.sax.ext.LexicalHandler;

/**
 * The foundation builder drives the notification process that
 * allows data builders to construct their data structure.
 *  
 * @author Ali Mehregani
 */
public interface IFoundationBuilder extends IValidator, LexicalHandler
{
	/**
	 * Processing instructions event
	 */
	public static final int EVENT_PROCESSING_INSTRUCTIONS = 0x00;	
	
	/** 
	 * Character event
	 */
	public static final int EVENT_CHARACTER = 0x01;		
	
	/** 
	 * Start document event
	 */
	public static final int EVENT_START_DOCUMENT = 0x02;			
	
	/** 
	 * End document event
	 */
	public static final int EVENT_END_DOCUMENT = 0x03;				
	
	/** 
	 * Start prefix mapping event
	 */
	public static final int EVENT_START_PREFIX = 0x04;		
	
	/** 
	 * End prefix mapping event
	 */
	public static final int EVENT_END_PREFIX = 0x05;				
	
	/** 
	 * Ignorable whitespace event
	 */
	public static final int EVENT_IGNORABLE_WHITESPACE = 0x06;		
	
	/** 
	 * Skipped entity event
	 */
	public static final int EVENT_SKIPPED_ENTITY = 0x07;				
	
	/** 
	 * Comment event
     */
	public static final int EVENT_COMMENT = 0x08;					
	
	
	
	
}
