/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.core;

import java.util.ArrayList;
import java.util.List;


/**
 * This factory class is used to create the different validators that 
 * will be used as part of the validation process.
 * 
 * @author Ali Mehregani
 */
public class ValidationFactory
{
	/**
	 * Constructs and returns a set of validators based on the class type and the
	 * classes passed in.
	 * 
	 * @param classType The class type of the validator
	 * @param classes The validator classes that should be used
	 * @return A set of validators corresponding to the class type and attributes
	 * passed in.
	 * @throws IllegalAccessException 
	 * @throws InstantiationException 
	 * @throws ClassNotFoundException 
	 */
	@SuppressWarnings("unchecked")
	public static IValidator[] createValidator(Class<?> classType, Object classes) throws InstantiationException, IllegalAccessException, ClassNotFoundException
	{
		/* SML Validators */
		if (classType == ISMLValidator.class)
		{
			List<String> classNameList = null;
			if (!(classes instanceof List) || (classNameList = (List)classes).isEmpty())
				return new IValidator[0];
			
			List<IValidator> validatorList = new ArrayList<IValidator>(classNameList.size());
			for (int i = 0, classNameListCount = classNameList.size(); i < classNameListCount; i++)
			{
				Class<IValidator> validatorClass = (Class<IValidator>)Class.forName((String)classNameList.get(i));
				validatorList.add(validatorClass.newInstance());
			}
			
			return (IValidator[])validatorList.toArray(new IValidator[validatorList.size()]);
		}
		
		return new IValidator[0];
	}

}
