/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import org.eclipse.cosmos.rm.validation.internal.SMLActivator;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.validation.internal.common.ISMLConstants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * Constructs a map that stores the relationship between the element names and their
 * associated type. 
 * 
 * @author Ali Mehregani
 */
public class ElementTypeMapDataBuilder extends AbstractDataBuilder<ElementTypeMap>
{
	/**
	 * The ID of this builder
	 */
	public static final String ID = SMLActivator.PLUGIN_ID + ".ElementTypeMapDataBuilder";
	
	/**
	 * The structure used to store the element name and type relationship
	 */
	private ElementTypeMap elementTypeMap;
	
	public ElementTypeMapDataBuilder()
	{
		elementTypeMap = new ElementTypeMap();
	}
	
	
	/**
	 * @see org.xml.sax.helpers.DefaultHandler#startElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
	 */
	public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException
	{
		super.startElement(uri, localName, qName, attributes);
		if (ISMLConstants.SCHEMA_URI.equals(uri) && ISMLConstants.ELEMENT_ELEMENT.equals(localName))
		{
			String name = attributes.getValue(ISMLConstants.NAME_ATTRIBUTE);
			String type = attributes.getValue(ISMLConstants.TYPE_ATTRIBUTE);
			
			if (name != null && type != null)
			{
				String[] tokenizedQName = tokenizeName(type);
				String typeURI = tokenizedQName[0] == null ? super.getDefaultNamespace() : (String)super.getPrefixMap().get(tokenizedQName[0]);
				if (typeURI != null && name != null && tokenizedQName[1] != null)
					elementTypeMap.addElementDeclaration(typeURI, name, tokenizedQName[1]);
				
			}
		}
	}



	/**
	 * An object of type {@link ElementTypeMap} which indicates the element name
	 * and type relationship.
	 * 
	 * @see org.eclipse.cosmos.rm.validation.internal.artifacts.ElementTypeMap
	 * @see org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder#getDataStructure()
	 */
	public ElementTypeMap getDataStructure()
	{		
		return elementTypeMap;
	}

	
	/**
	 * @see org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder#getPhase()
	 */
	public byte getPhase()
	{
		return ISMLConstants.DEFINITIONS_PHASE;
	}

}
