/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import org.eclipse.cosmos.rm.validation.internal.SMLActivator;
import org.eclipse.cosmos.rm.validation.internal.artifacts.MappedNamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NamespaceContextBuilder extends AbstractDataBuilder<MappedNamespaceContext>
{
	/**
	 * The ID of this data builder
	 */
	public static final String ID = SMLActivator.PLUGIN_ID + ".NamespaceContextBuilder";
	
	/**
	 * The mapped namespace
	 */
	private MappedNamespaceContext mappedNamespace;
	
	/**
	 * Constructor
	 */
	public NamespaceContextBuilder()
	{
		mappedNamespace = new MappedNamespaceContext();
	}
	
	public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException
	{
		/* Does not need to be implemented */ 
	}
	
	public void endElement(String uri, String localName, String qName) throws SAXException
	{
		/* Does not need to be implemented */
	}

	public MappedNamespaceContext getDataStructure()
	{		
		return mappedNamespace;
	}
	

}
