/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import org.eclipse.cosmos.rm.validation.internal.SMLActivator;
import org.eclipse.cosmos.rm.validation.internal.artifacts.SchemaBindings;
import org.eclipse.cosmos.rm.validation.internal.common.ISMLConstants;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput.ValidationMessageFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * Currently schema bindings is not supported by the validator.  This data builder is
 * currently used to display a warning for documents using a schema binding element.
 * According to the specification consumers of SML-IF documents are not required to 
 * support schema bindings:
 * 
 * "SML-IF consumers MAY choose to ignore the schemaBindings element when present in the 
 * SML-IF document, in which case the consumer SHOULD make its invoker aware of this situation. 
 * The remainder of this section applies to SML-IF consumers who choose to process the schemaBindings 
 * element."
 * See {@link http://www.w3.org/TR/2008/WD-sml-if-20080114/#Schema_Document_Bindings1}
 * 
 * @author Ali Mehregani
 */
public class SchemaBindingDataBuilder extends AbstractDataBuilder<SchemaBindings>
{
	/**
	 * The ID of this builder
	 */
	public static final String ID = SMLActivator.PLUGIN_ID + ".SchemaBindingDataBuilder";
	
	/**
	 * @see org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder#startElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
	 */
	public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException
	{
		if (ISMLConstants.SCHEMA_BINDINGS_ELEMENT.equals(localName) && ISMLConstants.SMLIF_URI.equals(uri))
		{
			getMessageOutputter().reportMessage(ValidationMessageFactory.createErrorMessage(
					locator.getLineNumber(), SMLValidationMessages.warningSchemaBinding));
		}
	}
	
	
	/**
	 * @see org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder#getPhase()
	 */
	public byte getPhase()
	{
		return ISMLConstants.START_PHASE;
	}
	
	
	/**
	 * @see org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder#getDataStructure()
	 */
	public SchemaBindings getDataStructure()
	{		
		return new SchemaBindings();
	}
}
