/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.reference;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.NamespaceContext;

import org.eclipse.cosmos.rm.validation.internal.artifacts.ReferenceDescriptor;

/**
 * A data structure that stores SML references.
 * An element of this type is identified by the sml:ref="true" attribute
 * The element can contain one or more reference schemes
 * (default reference scheme is sml:uri, modeled by the URIReference class)
 * 
 * @author Valentina Popescu
 * @author Ali Mehregani
 */
public class ReferenceContext
{
	private int lineNumber;
	private String filePath;
	
	private boolean isNilref;
	
	private String elementName;
	private String namespace;
	
	/**
	 * The namespace mapping for this reference context
	 */
	private NamespaceContext namespaceContext;
	
	/**
	 * list of reference schemes contained by this SML reference
	 */
	private List<ReferenceDescriptor> referenceDescriptors;
	
	
	public ReferenceContext(String filePath, int lineNumber)
	{
		this.filePath = filePath;
		this.lineNumber = lineNumber;
		isNilref = false;
		referenceDescriptors = new ArrayList<ReferenceDescriptor>();
	}
	
	
	/**
	 * @return the lineNumber
	 */
	public int getLineNumber() {
		return lineNumber;
	}


	/**
	 * @return the filePath
	 */
	public String getFilePath() {
		return filePath;
	}


	/**
	 * @param lineNumber the lineNumber to set
	 */
	public void setLineNumber(int lineNumber) {
		this.lineNumber = lineNumber;
	}


	/**
	 * @param filePath the filePath to set
	 */
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}


	/**
	 * @return the isNilref
	 */
	public boolean isNilref() {
		return isNilref;
	}


	/**
	 * @param isNilref the isNilref to set
	 */
	public void setNilref(boolean isNilref) {
		this.isNilref = isNilref;
	}


	/**
	 * @return the schemes
	 */
	public List<ReferenceDescriptor> getReferenceDescriptors() {
		return referenceDescriptors;
	}


	/**
	 * @param schemes the schemes to set
	 */
	public void setReferenceDescriptors(List<ReferenceDescriptor> referenceDescriptors) {
		this.referenceDescriptors = referenceDescriptors;
	}


	/**
	 * @return the elementName
	 */
	public String getElementName() {
		return elementName;
	}


	/**
	 * @param elementName the elementName to set
	 */
	public void setElementName(String elementName) {
		this.elementName = elementName;
	}


	/**
	 * @return the namespace
	 */
	public String getNamespace() {
		return namespace;
	}


	/**
	 * @param namespace the namespace to set
	 */
	public void setNamespace(String namespace) {
		this.namespace = namespace;
	}


	public void addReferenceScheme(ReferenceDescriptor ref) {
		
		referenceDescriptors.add(ref);
		
	}


	/**
	 * @return the namespaceContext
	 */
	public NamespaceContext getNamespaceContext()
	{
		return namespaceContext;
	}


	/**
	 * @param namespaceContext the namespaceContext to set
	 */
	public void setNamespaceContext(NamespaceContext namespaceContext)
	{
		this.namespaceContext = namespaceContext;
	}
	
}
