/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.reference;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathFunctionException;

import org.w3c.dom.NodeList;

/**
 * This class provides xslt extension functions.  Note this class is specific to the xalan tranform engine
 * 
 * @author sleeloy
 */
public class SMLExtensionFunctions
{

	/**
	 * SML deref function
	 * @param context - contains xpah context information such as the current node
	 * @param nl - the list node that is passed as a parameter to the function
	 * @return a node list
	 * @throws XPathFunctionException 
	 */
	public Object deref(NodeList nl) throws XPathFunctionException
	{		
		return this.deref((Object)nl);
	}	
	
	public Object deref (String expression) throws XPathFunctionException
	{
		return this.deref((Object)expression);
	}
	
	private Object deref (Object object) throws XPathFunctionException
	{
		List<Object> list = new ArrayList<Object>();
		list.add(object);
		Object result = DerefXPathFunction.instance().evaluate(list);
		return result;		
	}
}
