/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.validation.internal.util;
/**
 * ParserHelper provides parser helper apis 
 * @author sleeloy
 *
 */
public class ParserHelper {

	/**
	 * Removes namespace prefix from the name passed in
	 * @param name string containing a namespace
	 * @return string with the namespace removed
	 */
	public static String removeNameSpace(String name){
		if (name == null) return name;
		int colonIndex = name.indexOf(":")+1;
		if (colonIndex == 0) return name;
		return name.substring(colonIndex);
		
	}
}
