/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.smlif.internal.common;

import java.util.Hashtable;

import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.core.SMLRepositoryFactory;
import org.eclipse.cosmos.rm.repository.exception.MissingRepositoryException;
import org.eclipse.cosmos.rm.repository.exception.RepositoryConnectionException;
import org.eclipse.cosmos.rm.repository.internal.core.FileSystemSMLRepository;
import org.eclipse.cosmos.rm.repository.internal.core.IFileSystemSMLProperties;

/**
 * Manages the instance of the repository used by the import/export
 * wizard.
 * 
 * @author Ali Mehregani
 */
public class SMLRepositoryManager
{
	/**
	 * The repository
	 */
	private static ISMLRepository repository;
	
	public static ISMLRepository getRepository()
	{
		if (repository == null || !repository.isConnection())
		{
			try
			{
				repository = SMLRepositoryFactory.createRepository();
			} catch (MissingRepositoryException e)
			{
				repository = new FileSystemSMLRepository();
			}
			
			try
			{
				Hashtable<String, Object> attributes = new Hashtable<String, Object>();
				attributes.put(IFileSystemSMLProperties.SUPPRESS_CONNECT_ERRORS, Boolean.TRUE);
				repository.connect(attributes);
			} 
			catch (RepositoryConnectionException e)
			{				
				e.printStackTrace();
			}
		}
		
		return repository;
	}
	
	
	public static ISMLRepository getRepository(String context, boolean reuse)
	{		
		if (!reuse && repository != null)
			repository.disconnect();
			
		ISMLRepository repository = getRepository();
		context = context.replace('\\', '/');
		repository.setProperty(IFileSystemSMLProperties.ROOT_DIRECTORY, context);
		return repository;
	}
	
	
	public static ISMLRepository getRepository(String context)
	{
		return getRepository (context, true);
	}
}
