/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import org.eclipse.cosmos.rm.smlif.internal.common.SMLConstants;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;

public class EditableComboBoxCellEditor extends ComboBoxCellEditor {

	public EditableComboBoxCellEditor(Composite parent, String[] items, int style) {
		super(parent, items, style);
		
	}

	protected Object doGetValue() {
		return getCombo().getText();
	}
	
	protected void doSetValue(Object value) {
		if (value instanceof Integer) {
			super.doSetValue(value);
			return;
		}
		String text = (String) value;
		if (value == null) {
			text = SMLConstants.ANY_DOCUMENT_ALIAS;
		}
		getCombo().setText(text);
	}
	
	protected CCombo getCombo() {
		return (CCombo) getControl();
	}
}
