/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import org.eclipse.cosmos.rm.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.validation.internal.artifacts.RuleBinding;

/**
 * Specialized rule binding for presentation in export wizard
 * 
 * @author David Whiteman
 */
public class ExportWizardRuleBinding extends RuleBinding {

	protected ISMLDocument document;
		
	public ExportWizardRuleBinding(ISMLDocument document, String alias, String rule) {
		super(alias, rule);
		this.document = document;
	}

	public ExportWizardRuleBinding() {
		super();
	}

	public ExportWizardRuleBinding(String docAlias, String ruleAlias) {
		super(docAlias, ruleAlias);
	}

	public ISMLDocument getDocument() {
		return document;
	}

	public void setDocument(ISMLDocument document) {
		this.document = document;
	}
}
