/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import java.util.List;
import java.util.Map;

import org.eclipse.cosmos.rm.validation.internal.artifacts.RuleBinding;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;

/**
 * Cell modifier for handling input from and output to editor
 * 
 * @author David Whiteman
 */
public class RuleBindingTableCellModifier implements ICellModifier {

	private static final Integer NOT_FOUND = new Integer(-1);
	private ExportToSMLIFWizardPage3 wizardPage;
	private List<String> columnProperties;
	private Map<String, String[]> userDefinedAliases;
	
	
	public RuleBindingTableCellModifier(List<String> list, ExportToSMLIFWizardPage3 wizardPage, Map<String, String[]> userDefinedAliases) {
		super();
		this.wizardPage = wizardPage;
		this.columnProperties = list;
		this.userDefinedAliases = userDefinedAliases;
	}

	public boolean canModify(Object element, String property) {
		return true;
	}

	public Object getValue(Object element, String property) {
		int columnIndex = columnProperties.indexOf(property);
		Object modelDataForColumn = RuleBindingTableLabelProvider.getModelDataForColumn(element, columnIndex);
		if (modelDataForColumn == null) {
			return NOT_FOUND;
		}
		if (ExportToSMLIFWizardPage3.ALIAS_COLUMN.equals(property)) {
			String alias = (String) modelDataForColumn;
			String[] aliasChoices = wizardPage.aliasChoicesCombo.getItems();
			for (int i = 0; i < aliasChoices.length; i++) {
				if (aliasChoices[i].equals(alias)) {
					return new Integer(i);
				}
			}
			return alias;
			
		} else if (ExportToSMLIFWizardPage3.RULE_COLUMN.equals(property)) {
			String rule = (String) modelDataForColumn;
			String[] ruleChoices = wizardPage.ruleChoicesCombo.getItems();
			for (int i = 0; i < ruleChoices.length; i++) {
				if (ruleChoices[i].equals(rule)) {
					return new Integer(i);
				}
			}
			//return NOT_FOUND;
			return rule;
		}
		return NOT_FOUND;
	}

	public void modify(Object element, String property, Object value) {
		int columnIndex = columnProperties.indexOf(property);
		RuleBinding ruleBinding = null;
		if (element instanceof Item) {
			TableItem item = (TableItem) element;
			ruleBinding = (RuleBinding) item.getData();
		} else {
			ruleBinding = (RuleBinding) element;
		}
		int selectionIndex = -1;
		if (value instanceof Integer) {
			selectionIndex = ((Integer) value).intValue();
		}
		switch (columnIndex) {
		case 0:
			String alias = null;
			if (selectionIndex == -1) {
				alias = ((CCombo) wizardPage.aliasChoicesCombo.getControl()).getText();
			} else {
				alias = wizardPage.aliasChoicesCombo.getItems()[selectionIndex];
			}
			ruleBinding.setAlias(alias);
			break;
		case 1:
			String rule = null;
			if (selectionIndex == -1) {
				rule = ((CCombo) wizardPage.ruleChoicesCombo.getControl()).getText();
			} else {
				rule = wizardPage.ruleChoicesCombo.getItems()[selectionIndex];
			}
			ruleBinding.setRule(rule); 
			break;
		default:
			break;
		}
		wizardPage.ruleBindingsTableViewer.refresh();
	}

}
