/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.rm.smlif.internal.importing.ui;

import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

/**
 * Wizard for importing SML-IF files into the workspace, as individual files
 * for the instance and definition SML documents therein.  Also preserves metadata from
 * the SML-IF file that isn't persisted in SML documents.
 * 
 * @author David Whiteman
 */
public class ImportFromSMLIFWizard extends Wizard implements IImportWizard {
	
	protected ImportFromSMLIFWizardPage mainPage;
	protected IStructuredSelection selection = null;
	protected String initialDestinationDir = null;

	public ImportFromSMLIFWizard(String initialDestinationDir) {
		super();
		this.initialDestinationDir = initialDestinationDir;
	}

	public ImportFromSMLIFWizard() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	public boolean performFinish() {
		return mainPage.doImport();
	}
	 
	/* (non-Javadoc)
     * @see org.eclipse.jface.wizard.IWizard#addPages()
     */
    public void addPages() {
        super.addPages();
        
		mainPage = new ImportFromSMLIFWizardPage(SMLMessages.importWizardPageTitle, selection); //NON-NLS-1
		mainPage.setDescription(SMLMessages.importWizardFileInstruction);
		
		if ((initialDestinationDir != null) && !("".equals(initialDestinationDir))) {
			mainPage.setInitialDestinationDir(initialDestinationDir);
		}
        
        addPage(mainPage);
        
        setWindowTitle(SMLMessages.importWizardTitle);
    }

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection = selection;
	}

}
