/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.rm.smlif.internal.newfile.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.rm.repository.internal.ISMLRepositoryConstants;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLIFIdentity;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

/**
 * Wizard for creating new SML-IF file from New menu
 * 
 * @author David Whiteman
 */
public class NewFileWizard extends Wizard implements INewWizard {

	private IStructuredSelection initialSelection;
	private WizardNewFileCreationPage wizardNewFileCreationPage;
	private IWorkbench workbench;
	private NewFileWizardIdentityPage newFileWizardIdentityPage;
	private IFile file;

	public NewFileWizard() {
	}

	public boolean performFinish() {
        file = wizardNewFileCreationPage.createNewFile();
        if (file == null) {
			return false;
		}
        
        fillInContents(file);
        
        // selectAndReveal() ?

 		Runnable runnable = new Runnable() {
			public void run() {
				openEditor();
			}
		};
		org.eclipse.swt.custom.BusyIndicator.showWhile(null, runnable);

        return true;
	}
	
	private void fillInContents(IFile file) {
		StringBuffer buffer = new StringBuffer();
		SMLRepositoryUtil.appendSMLIFIdentityInformation(buffer, 
				new SMLIFIdentity(null, newFileWizardIdentityPage.getNameText().getText(),
						newFileWizardIdentityPage.getDescriptionText().getText(), 
						newFileWizardIdentityPage.getDisplayNameText().getText(),
						newFileWizardIdentityPage.getVersionText().getText(),
						newFileWizardIdentityPage.getBaseURIText().getText()));

		buffer.append(ISMLRepositoryConstants.smlifEnd);
		InputStream stream = new ByteArrayInputStream(buffer.toString().getBytes());
		try {
			file.appendContents(stream, IFile.FORCE, null);
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	public void addPages() {
		setWindowTitle(SMLMessages.newFileWizardTitle);
		wizardNewFileCreationPage = new WizardNewFileCreationPage(SMLMessages.newFileWizardCreationPageName, initialSelection);
		wizardNewFileCreationPage.setTitle(SMLMessages.newFileWizardCreationPageTitle);
		wizardNewFileCreationPage.setDescription(SMLMessages.newFileWizardCreationPageDescription);
		addPage(wizardNewFileCreationPage);
		newFileWizardIdentityPage = new NewFileWizardIdentityPage();
		addPage(newFileWizardIdentityPage);
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.workbench = workbench;
		initialSelection = selection;
	}

	private void openEditor() {
		// Open editor on new file.
		IWorkbenchWindow dw = workbench.getActiveWorkbenchWindow();
		try {
		    if (dw != null) {
		        IWorkbenchPage page = dw.getActivePage();
		        if (page != null) {
		            IDE.openEditor(page, file, true);
		        }
		    }
		} catch (PartInitException e) {
			SMLCommonUtil.openErrorWithDetail(SMLMessages.newFileWizardErrorOpeningEditor, 
		            e.getMessage(), e);
		}
	}

}
