/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.rm.smlif.internal.newfile.ui;


import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * Second page of the new SMLIF file wizard, for inputting
 * Identity fields.
 * 
 * @author David Whiteman
 */
public class NewFileWizardIdentityPage extends WizardPage {

	private Text nameText;
	private Text versionText;
	private Text displayNameText;
	private Text baseURIText;
	private Text descriptionText;

	protected NewFileWizardIdentityPage() {
		super(SMLMessages.newFileWizardIdentityPageName);
		setTitle(SMLMessages.newFileWizardIdentityPageTitle);
		setDescription(SMLMessages.newFileWizardIdentityPageDescription);
	}

	public void createControl(Composite parent) {
		Composite topComponent = new Composite(parent, SWT.NULL);
		GridData topComponentData = new GridData(GridData.GRAB_HORIZONTAL
				| GridData.FILL_HORIZONTAL);
		topComponent.setLayoutData(topComponentData);

		GridLayout topComponentLayout = new GridLayout();
		topComponentLayout.numColumns = 2;
		topComponentLayout.makeColumnsEqualWidth = false;
		topComponent.setLayout(topComponentLayout);

		nameText = createTextField(topComponent, SMLMessages.editorName, false);
		versionText = createTextField(topComponent, SMLMessages.editorVersion, false);
		displayNameText = createTextField(topComponent, SMLMessages.editorDisplayName, false);
		baseURIText = createTextField(topComponent, SMLMessages.editorBaseURI, false);
		SMLCommonUtil.addURIValidator(baseURIText, new SMLPage(this));
		descriptionText = createTextField(topComponent, SMLMessages.editorDescription, true);

		setControl(topComponent);
//		updatePageComplete();
		Dialog.applyDialogFont(topComponent);
	}

	private Text createTextField(Composite destGroup, String editorName, boolean multiLine) {
		Label label = new Label(destGroup, SWT.LEFT);
		label.setText(editorName);
		GridData lblGD = new GridData(SWT.DEFAULT, SWT.TOP, false, false);
		label.setLayoutData(lblGD);
		
		Text text = new Text(destGroup, multiLine ? SWT.BORDER | SWT.V_SCROLL | SWT.WRAP : SWT.BORDER);

		GridData gridData = new GridData(SWT.FILL, SWT.DEFAULT, true, false);
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = GridData.FILL;
		if (multiLine) {			
			gridData.heightHint = 200;
		}
		text.setLayoutData(gridData);
		return text;
	}

	public Text getBaseURIText() {
		return baseURIText;
	}

	public Text getDescriptionText() {
		return descriptionText;
	}

	public Text getDisplayNameText() {
		return displayNameText;
	}

	public Text getNameText() {
		return nameText;
	}

	public Text getVersionText() {
		return versionText;
	}
	

}
