/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IContentSelectorSupport;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IQueryCapabilities;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRecordConstraintSupport;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRelationshipTemplateSupport;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IXpathSupport;

public class QueryCapabilities implements IQueryCapabilities 
{
	private IRelationshipTemplateSupport relationshipTemplateSupport = null;
	private IContentSelectorSupport contentSelectorSupport = null;
	private IRecordConstraintSupport recordConstraintSupport = null;
	private IXpathSupport xpathSupport = null;

	
	/**
	 * set the relationshipTemplateSupport in the queryCapabilities
	 * 
	 * @param relationshipTemplateSupport
	 */
	public void setRelationshipTemplateSupport(IRelationshipTemplateSupport relationshipTemplateSupport){
		this.relationshipTemplateSupport = relationshipTemplateSupport;
	}
		
	/**
	 * Retrieve the relationshipTemplateSupport
	 * 
	 * @return IRelationshipTemplateSupport
	 */
	public IRelationshipTemplateSupport getRelationshipTemplateSupport(){
		return relationshipTemplateSupport;
	}
	
	
	/**
	 * set the contentSelectorSupport in the queryCapabilities
	 * 
	 * @param contentSelectorSupport
	 */
	public void setContentSelectorSupport(IContentSelectorSupport contentSelectorSupport){
		this.contentSelectorSupport = contentSelectorSupport;
	}
		
	/**
	 * Retrieve the contentSelectorSupport
	 * 
	 * @return IContentSelectorSupport
	 */
	public IContentSelectorSupport getContentSelectorSupport(){
		return contentSelectorSupport;
	}
	
	
	/**
	 * set the recordConstraintSupport in the queryCapabilities
	 * 
	 * @param recordConstraintSupport
	 */
	public void setRecordConstraintSupport(IRecordConstraintSupport recordConstraintSupport){
		this.recordConstraintSupport = recordConstraintSupport;
	}
		
	/**
	 * Retrieve the recordConstraintSupport
	 * 
	 * @return IRecordConstraintSupport
	 */
	public IRecordConstraintSupport getRecordConstraintSupport(){
		return recordConstraintSupport;
	}
	
	
	/**
	 * set the xpathSupport in the queryCapabilities
	 * 
	 * @param xpathSupport
	 */
	public void setXpathSupport(IXpathSupport xpathSupport){
		this.xpathSupport = xpathSupport;
	}
		
	/**
	 * Retrieve the xpathSupport
	 * 
	 * @return IXpathSupport
	 */
	public IXpathSupport getXpathSupport(){
		return xpathSupport;
	}

	
	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write( ICMDBfServicesConstants.OPEN_ANGLE_BRACKET+ServiceMetadataConstants.QUERYCAPABILITIES_ELEMENT +
				      ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
		
		if ( relationshipTemplateSupport != null ){
			relationshipTemplateSupport.toXML( writer, indent + 1 );
		}

		if ( contentSelectorSupport != null ){
			contentSelectorSupport.toXML( writer, indent + 1 );
		}

		if ( recordConstraintSupport != null ){
			recordConstraintSupport.toXML( writer, indent + 1 );
		}

		if ( xpathSupport != null ){
			xpathSupport.toXML( writer, indent + 1 );
		}

		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ServiceMetadataConstants.QUERYCAPABILITIES_ELEMENT)+ICMDBfServicesConstants.nl);
	}


	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final QueryCapabilities other = (QueryCapabilities) obj;
		if (relationshipTemplateSupport == null) {
			if (other.relationshipTemplateSupport != null)
				return false;
		} else if (!relationshipTemplateSupport.equals(other.relationshipTemplateSupport))
			return false;
		
		if (contentSelectorSupport == null) {
			if (other.contentSelectorSupport != null)
				return false;
		} else if (!contentSelectorSupport.equals(other.contentSelectorSupport))
			return false;
		
		if (recordConstraintSupport == null) {
			if (other.recordConstraintSupport != null)
				return false;
		} else if (!recordConstraintSupport.equals(other.recordConstraintSupport))
			return false;
		
		if (xpathSupport == null) {
			if (other.xpathSupport != null)
				return false;
		} else if (!xpathSupport.equals(other.xpathSupport))
			return false;
		
		return true;
	}
	
}
