/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRelationshipTemplateSupport;


public class RelationshipTemplateSupport implements IRelationshipTemplateSupport 
{
	private boolean depthLimit;
	private boolean minimumMaximum;

	
	/**
	 * set the depthLimit 
	 * 
	 * @param depthLimit
	 */
	public void setDepthLimit(boolean depthLimit){
		this.depthLimit = depthLimit;
	}
		
	/**
	 * Retrieve the depthLimit
	 * 
	 * @return depthLimit
	 */
	public boolean isDepthLimit(){
		return depthLimit;
	}

	
	/**
	 * set the minimumMaximum
	 * 
	 * @param minimumMaximum
	 */
	public void setMinimumMaximum(boolean minimumMaximum){
		this.minimumMaximum = minimumMaximum;
	}
		
	/**
	 * Retrieve the minimumMaximum
	 * 
	 * @return Boolean minimumMaximum
	 */
	public boolean isMinimumMaximum(){
		return minimumMaximum;
	}

	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.tagFor(false, null, ServiceMetadataConstants.RELATIONSHIPTEMPLATESUPPORT_ELEMENT, false));
		
		writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, ServiceMetadataConstants.DEPTHLIMIT_ATTRIBUTE, String.valueOf(depthLimit));
		
		writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
		CMDBfServicesUtil.writeAttribute(writer, ServiceMetadataConstants.MINIMUMMAXIMUM_ATTRIBUTE, String.valueOf(minimumMaximum));		
		writer.write(ICMDBfServicesConstants.FORWARD_SLASH+ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
	}


	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RelationshipTemplateSupport other = (RelationshipTemplateSupport) obj;		
		return 	depthLimit == other.depthLimit &&
				minimumMaximum == other.minimumMaximum;
	}
}
