/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IServiceDescription;


public class ServiceDescription implements IServiceDescription 
{
	private String mdrId = null;
	private String description = null;

	
	/**
	 * set the mdrId of the ServiceDescription
	 * 
	 * @param mdrId
	 */
	public void setMdrId(String mdrId){
		this.mdrId = mdrId;
	}
		
	/**
	 * Retrieve an mdrId
	 * 
	 * @return mdrId
	 */
	public String getMdrId(){
		return mdrId;
	}

	
	/**
	 * set the description of the ServiceDescription
	 * 
	 * @param description
	 */
	public void setDescription(String description){
		this.description = description;
	}
		
	/**
	 * Retrieve a description
	 * 
	 * @return String description
	 */
	public String getDescription(){
		return description;
	}

	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ServiceMetadataConstants.SERVICEDESCRIPTION_ELEMENT)+ICMDBfServicesConstants.nl);
		
		if ( mdrId != null){
			CMDBfServicesUtil.addIndent(writer, indent + 1);
			writer.write(CMDBfServicesUtil.beginTagFor(ServiceMetadataConstants.MDRID_ELEMENT));
			writer.write(mdrId);
			writer.write(CMDBfServicesUtil.endTagFor(ServiceMetadataConstants.MDRID_ELEMENT)+ICMDBfServicesConstants.nl);
		}
		
		if ( description != null){
			CMDBfServicesUtil.addIndent(writer, indent + 1);
			writer.write(CMDBfServicesUtil.beginTagFor(ServiceMetadataConstants.DESCRIPTION_ELEMENT));
			writer.write(description);
			writer.write(CMDBfServicesUtil.endTagFor(ServiceMetadataConstants.DESCRIPTION_ELEMENT)+ICMDBfServicesConstants.nl);
		}
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ServiceMetadataConstants.SERVICEDESCRIPTION_ELEMENT)+ICMDBfServicesConstants.nl);
	}


	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final ServiceDescription other = (ServiceDescription) obj;
		if (mdrId == null) {
			if (other.mdrId != null)
				return false;
		} else if (!mdrId.equals(other.mdrId))
			return false;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;

		return true;
	}
	
}
