/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.metadata.transform;

import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRegistrationServiceMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.MetadataArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.cmdbf.services.transform.TransformerException;
import org.xml.sax.InputSource;

/**
 * Conversions between XML query structures and Java object graphs
 * 
 * @provisional
 * @author Bill Muldoon
 */
public class RegistrationMetadataTransformer {

	/**
	 * Convert an IRegistrationServiceMetadata into the XML syntax for queries described in the CMBDf spec
	 * 
	 * @param registrationServiceMetadata
	 * @return an input stream on the XML containing the <registrationServiceMetadata> structure
	 */
	public static InputStream transform(IRegistrationServiceMetadata registrationServiceMetadata) {
		return CMDBfServicesUtil.transformImpl((IXMLWritable) registrationServiceMetadata);
	}

	/**
	 * Convert input stream containing an XML structure for a CMDBf registrationServiceMetadata into a
	 * Java object graph
	 * 
	 * @param xmlInputStream
	 * @return IRegistrationServiceMetadata object structure representing a query
	 * @throws TransformerException
	 */
	public static IRegistrationServiceMetadata transform(InputStream xmlInputStream) throws TransformerException {
		return transform (xmlInputStream, MetadataArtifactFactory.getInstance(), null);	
	}
	
	/**
	 * Convert input stream containing an XML structure for a CMDBf registrationServiceMetadata into a
	 * Java object graph.  Use the passed in artifact factory to create POJOs.
	 * 
	 * @param xmlInputStream
	 * @param artifactFactory
	 * @return IRegistrationServiceMetadata object structure representing a query
	 * @throws TransformerException
	 */
	public static IRegistrationServiceMetadata transform(InputStream xmlInputStream, IMetadataArtifactFactory artifactFactory) throws TransformerException {
		return transform (xmlInputStream, artifactFactory, null);	
	}
	
	/**
	 * Convert input stream containing an XML structure for a CMDBf registrationServiceMetadata into a
	 * Java object graph
	 * 
	 * @param reader
	 * @return IRegistrationServiceMetadata object structure representing a query
	 * @throws TransformerException
	 */
	public static IRegistrationServiceMetadata transform(Reader reader) throws TransformerException {
		return transform (reader, MetadataArtifactFactory.getInstance(), null);	
	}

	/**
	 * Convert input stream containing an XML structure for a CMDBf registrationServiceMetadata into a
	 * Java object graph.  Use the passed in artifact factory for creating POJOs.
	 * 
	 * @param reader
	 * @param artifactFactory
	 * @return IRegistrationServiceMetadata object structure representing a query
	 * @throws TransformerException
	 */
	public static IRegistrationServiceMetadata transform(Reader reader, IMetadataArtifactFactory artifactFactory) throws TransformerException {
		return transform (reader, artifactFactory, null);	
	}

	/**
	 * Convert input stream containing an XML structure for a CMDBf registrationServiceMetadata into a
	 * Java object graph.  Can specify one of the following options:
	 * {@value ICMDBfServicesConstants#SERVICES_TRANSFORM_VALIDATION_OPTION}
	 * {@value ICMDBfServicesConstants#SERVICES_TRANSFORM_DATAMODEL_OPTION}
	 * 
	 * @param xmlInputStream
	 * @param transformOptions a Map of options that affect default behavior of the transformer
	 * @return IRegistrationServiceMetadata object structure representing a query
	 * @throws TransformerException
	 */
	public static IRegistrationServiceMetadata transform(InputStream xmlInputStream, IMetadataArtifactFactory artifactFactory, Map<String, Object> transformOptions) throws TransformerException
	{
		return transformOptions == null ? 
				(IRegistrationServiceMetadata) CMDBfServicesUtil.transformImpl(new InputSource(xmlInputStream), (ITransformerHandler) new ServiceMetadataInputStreamHandler(false, artifactFactory)):
				(IRegistrationServiceMetadata) CMDBfServicesUtil.transformImpl(new InputSource(xmlInputStream), (ITransformerHandler) new ServiceMetadataInputStreamHandler(false, artifactFactory), transformOptions);	
	}
	
	/**
	 * Convert input stream containing an XML structure for a CMDBf registrationServiceMetadata into a
	 * Java object graph.  Can specify one of the following options:
	 * {@value ICMDBfServicesConstants#SERVICES_TRANSFORM_VALIDATION_OPTION}
	 * {@value ICMDBfServicesConstants#SERVICES_TRANSFORM_DATAMODEL_OPTION}
	 * 
	 * @param reader
	 * @param transformOptions a Map of options that affect default behavior of the transformer
	 * @return IRegistrationServiceMetadata object structure representing a query
	 * @throws TransformerException
	 */
	public static IRegistrationServiceMetadata transform(Reader reader, IMetadataArtifactFactory artifactFactory, Map<String, Object> transformOptions) throws TransformerException 
	{
		return transformOptions == null ? 
				(IRegistrationServiceMetadata) CMDBfServicesUtil.transformImpl(new InputSource(reader), (ITransformerHandler) new ServiceMetadataInputStreamHandler(false, artifactFactory)) :
				(IRegistrationServiceMetadata) CMDBfServicesUtil.transformImpl(new InputSource(reader), (ITransformerHandler) new ServiceMetadataInputStreamHandler(false, artifactFactory), transformOptions);	
	}

}
