/**********************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * CA - Initial API and implementation
 * IBM - provisional API change, removed IRootElement
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;

/**
 * Represents a <propertyValueOperators> element in XML form
 * 
 * @provisional
 * @author Bill Muldoon
 */
public interface IPropertyValueOperators extends IXMLWritable
{
	/**
	 * set the equal attribute 
	 * 
	 * @param equal
	 */
	public void setEqual(boolean equal);
		
	/**
	 * Retrieve the equal attribute
	 * 
	 * @return equal
	 */
	public boolean isEqual();

	
	/**
	 * set the less attribute 
	 * 
	 * @param less
	 */
	public void setLess(boolean less);
		
	/**
	 * Retrieve the less attribute
	 * 
	 * @return less
	 */
	public boolean isLess();

	
	/**
	 * set the lessOrEqual attribute 
	 * 
	 * @param lessOrEqual
	 */
	public void setLessOrEqual(boolean lessOrEqual);
		
	/**
	 * Retrieve the lessOrEqual attribute
	 * 
	 * @return lessOrEqual
	 */
	public boolean isLessOrEqual();

	
	/**
	 * set the greater attribute 
	 * 
	 * @param greater
	 */
	public void setGreater(boolean greater);
		
	/**
	 * Retrieve the greater attribute
	 * 
	 * @return greater
	 */
	public boolean isGreater();

	
	/**
	 * set the greaterOrEqual attribute 
	 * 
	 * @param greaterOrEqual
	 */
	public void setGreaterOrEqual(boolean greaterOrEqual);
		
	/**
	 * Retrieve the greaterOrEqual attribute
	 * 
	 * @return greaterOrEqual
	 */
	public boolean isGreaterOrEqual();

	
	/**
	 * set the contains attribute 
	 * 
	 * @param contains
	 */
	public void setContains(boolean contains);
		
	/**
	 * Retrieve the contains attribute
	 * 
	 * @return contains
	 */
	public boolean isContains();

	
	/**
	 * set the like attribute 
	 * 
	 * @param like
	 */
	public void setLike(boolean like);
		
	/**
	 * Retrieve the like attribute
	 * 
	 * @return like
	 */
	public boolean isLike();

	
	/**
	 * set the isNull attribute 
	 * 
	 * @param isNull
	 */
	public void setNull(boolean isNull);
		
	/**
	 * Retrieve the isNull attribute
	 * 
	 * @return isNull
	 */
	public boolean isNull();
}
