/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.exception;

/**
 * This exception is thrown when an operation has failed.  The 
 * exception usually wraps the cause of the error.
 * 
 * @provisional
 * @author Ali Mehregani
 */
public class RepositoryOperationException extends Exception
{
	/**
	 * Serial version UID
	 */
	private static final long serialVersionUID = 2248360192670332917L;
	
	public RepositoryOperationException(String message)
	{
		super(message);
	}			
	
	public RepositoryOperationException(Throwable cause)
	{
		super(cause);
	}	
	
    public RepositoryOperationException(String message, Throwable cause) 
    {
        super(message, cause);
    }
}
