/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.internal.core;

import java.util.Map;

import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryPlugin;

/**
 * The properties that can be set on the file-system based
 * repository.
 * 
 * @author Ali Mehregani
 */
public interface IFileSystemSMLProperties
{
	/**
	 * The root directory of the repository
	 */
	public static final String ROOT_DIRECTORY = "root.directory";
	
	/**
	 * The root context node name
	 */
	public static final String ROOT_CONTEXT_NODE = "root.context.node";
	
	/**
	 * This attribute is used to suppress all errors that may occur during the
	 * connection to the repository.
	 */
	public static final String SUPPRESS_CONNECT_ERRORS = "suppress.connect.errors";

	/**
	 * A boolean set to true if files can be overwritten without any notification; false otherwise.
	 * This property is false by default
	 */
	public static final String OVERWRITE_WITHOUT_NOTIFICATION = SMLRepositoryPlugin.PLUGIN_ID + ".OVERWRITE_FILES";;
	
	/**
	 * A boolean set to true to create any structure needed as part of an import operation;
	 * false otherwise.  This property is true by default. 
	 */
	public static final String CREATE_STRUCTURE = SMLRepositoryPlugin.PLUGIN_ID + ".CREATE_STRUCTURE";

	
	/**
	 * Stores the type information of the processed elements.
	 * The value of this property is a {@link Map} where 
	 * KEY = Name space URI
	 * VALUE = A {@link Map} where
	 * 	KEY = Element local name
	 *  Type = URI:element type  
	 */
	public static final String TYPE_INFORMATION = SMLRepositoryPlugin.PLUGIN_ID + ".TYPE_INFORMATION";

	/**
	 * Stores the hierarchy information of the element types
	 * KEY = Name space URI
	 * VALUE = A {@link Map} where
	 * 	KEY = The type name
	 *  VALUE = Name space URI:parent type name
	 */
	public static final String HIERARCHY_INFORMATION = SMLRepositoryPlugin.PLUGIN_ID + ".HIERARCHY_INFORMATION";
}
