/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.BaseProperty;

/**
 * Represents a nilled SML property
 * 
 * @author Ali Mehregani
 */
public class NullSMLProperty extends BaseProperty
{
	private static final String localName = "org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.NullSMLProperty";
	
	public NullSMLProperty()
	{
		super(CMDBfConstants.REPOSITORY_MDRID, localName);		
	}

	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.AbstractProperty#isNull()
	 */
	public boolean isNull()
	{
		return true;
	}
}
