/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractQueryHandlerFactory;

public class SMLConstraintHandlerFactory extends AbstractQueryHandlerFactory
{
	private static SMLConstraintHandlerFactory instance;
	
	/**
	 * Make the constructor invisible
	 */
	private SMLConstraintHandlerFactory()
	{		
	}
	
	public static SMLConstraintHandlerFactory getInstance()
	{
		if (instance == null)
		{
			instance = new SMLConstraintHandlerFactory();
		}
		return instance;
	}
	
	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractQueryHandlerFactory#createItemHandler()
	 */
	protected IItemTemplateHandler createItemHandler() throws CMDBfServiceException
	{		
		return new ItemTemplateHandler();
	}
	
	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractQueryHandlerFactory#createRelationshipHandler()
	 */
	protected IRelationshipTemplateHandler createRelationshipHandler() throws CMDBfServiceException
	{
		return new RelationshipTemplateHandler();
	}
	
	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory#createItemInstanceHandler()
	 */
	public IItemConstraintHandler createItemInstanceHandler()
	{
		return new ItemInstanceHandler();
	}

	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory#createItemPropertyHandler()
	 */
	public IItemConstraintHandler createItemPropertyHandler() 
	{
		return new ItemPropertyHandler();
	}

	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory#createItemRecordHandler()
	 */
	public IItemConstraintHandler createItemRecordHandler()
	{
		return new ItemRecordHandler();
	}

	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory#createItemXPathHandler()
	 */
	public IItemConstraintHandler createItemXPathHandler()
	{
		return new ItemXPathHandler();
	}
}
