/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IProperty;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.SimpleTypeProperty;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.StringProperty;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * A factory class used to create an instance of a SML property based
 * on a node that is passed in.
 * 
 * @author Ali Mehregani
 */
public class SMLPropertyFactory
{	
	public static IProperty create(Node node)
	{
		String value = retrieveValue (node);
		int type = determineType(value);
		
		switch (type)
		{
			case IProperty.BOOLEAN:
				return new SimpleTypeProperty(node, Boolean.parseBoolean(value));				
			case IProperty.INTEGER:
				return new SimpleTypeProperty(node, Integer.parseInt(value));
			case IProperty.DOUBLE:
				return new SimpleTypeProperty(node, Double.parseDouble(value));
			case IProperty.STRING:
				return new StringProperty(node, value);
		}
		
		return null;
	}

	
	private static String retrieveValue(Node node)
	{
		switch (node.getNodeType())
		{
			case Node.ATTRIBUTE_NODE:
				return node.getNodeValue();
			
			case Node.ELEMENT_NODE:
			
				// Append the value of text elements that are children of node
				NodeList children = node.getChildNodes();
				StringBuffer buffer = new StringBuffer();
				for (int i = 0, childCount = children.getLength(); i < childCount; i++)
				{
					Node child = children.item(i);
					if (child.getNodeType() == Node.TEXT_NODE)
					{
						String value = child.getNodeValue();
						if (value != null)
						{
							buffer.append(value.trim());
						}
					}
					else
					{
						break;
					}
				}
				
				return buffer.toString();				
		}
		
		return "";
	}
	
	
	private static int determineType(String value)
	{
		if (value == null)
		{
			return IProperty.UNKNOWN;
		}
		
		// Is it a boolean?
		if ("true".equals(value) || "false".equals(value))
		{			
			return IProperty.BOOLEAN;
		}
		
		// Is it an integer?
		try
		{
			Integer.parseInt(value);
			return IProperty.INTEGER;
		}
		catch (NumberFormatException nfe)
		{
		}
		
		// Is it a double?
		try
		{
			Double.parseDouble(value);
			return IProperty.DOUBLE;
		}
		catch (NumberFormatException nfe)
		{			
		}
				
		return IProperty.STRING;
	}
}
