/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.internal.resource;

import org.eclipse.cosmos.rm.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.resource.ISMLDefinitionDocument;
import org.eclipse.cosmos.rm.validation.internal.common.ISMLConstants;

/**
 * The file system implementation of the definition SML
 * document.
 * 
 * @author Ali Mehregani
 */
public class SMLFileDefinitionDocument extends SMLFileDocument implements ISMLDefinitionDocument
{
	/**
	 * Constructor
	 * 
	 * @param repository The repository
	 */
	public SMLFileDefinitionDocument(ISMLRepository repository)
	{
		super(repository);
	}

	
	/**
	 * @see org.eclipse.cosmos.rm.repository.resource.ISMLDefinitionDocument#retrieveTargetNamespace()
	 */
	public String retrieveTargetNamespace() throws RepositoryOperationException
	{
		return retrieveRootAttribute(ISMLConstants.SCHEMA_URI, ISMLConstants.TARGET_NAMESPACE_ATTRIBUTE);						
	}

}
