/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.operations;

import org.eclipse.cosmos.rm.repository.internal.operations.OperationEvent;

/**
 * An operation listener is used to be notified of certain 
 * events during the execution of an operation.
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface IProgressListener
{
	/**
	 * Interrupts the operation execution to determine what action
	 * to take
	 * 
	 * @param event The operation event
	 */
	public void operationInterrupted(OperationEvent event);
}
