/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.operations;

/**
 * The validate operation is used to validate an SML-IF document or a 
 * set of SML documents.
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface ISMLValidateOperation extends ISMLOperation
{
	/**
	 * The ID of this operation
	 */
    public static final String ID = "org.eclipse.cosmos.rm.repository.operations.ISMLValidateOperation";
    	
	
	/**
	 * Returns any internal error that may have occurred while
	 * performing the validation process.
	 * 
	 * @return Internal errors of this operation or an empty String
	 * array if there were no errors.
	 */
	public String[] getInternalErrors();
	
	
    /**
     * Reports on the status of the validation result
     * 
     * @return true if the validation has passed; false otherwise
     */
	public boolean getStatus();	
}
