/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.resource;

import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;

/**
 * Represents a definition SML document.  An object of this type should
 * always have getMetadata().getDocumentType() return {@link ISMLMetadata#DOCUMENT_TYPE_DEFINITION}
 *
 * @provisional
 * @author Ali Mehregani
 */
public interface ISMLDefinitionDocument extends ISMLDocument
{
	/**
	 * Retrieves the target name space of this SML definition
	 * document.
	 * 
	 * @return The target name space if one exists; null otherwise
	 * @throws RepositoryOperationException In case of an error
	 */
    public String retrieveTargetNamespace()  throws RepositoryOperationException;
}
