/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.resource;

import javax.xml.namespace.NamespaceContext;

import org.eclipse.cosmos.rm.repository.exception.RepositoryOperationException;
import org.w3c.dom.Node;

/**
 * Represents an SML document.  Associated with each document is a 
 * meta-data object that store meta information about the document.  The retrieval
 * operations should be used with care if the implementation will require a 
 * separate read for each. 
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface ISMLDocument
{       
    /**
     * Retrieves and returns a document fragment based on the context node
     * and the XPath expression that is passed in.  The contextNode should be set
     * to null if the XPath should be applied using the root node as the context.
     * 
     * @param namespaceContext The namespace context used when evaluating the xpath expression
     * @param contextNode The context node for the XPath expression
     * @param xpathExpression The XPath expression
     * @return The SML fragment resulting from the XPath query
     * @throws RepositoryOperationException In case of an error
     */
    public ISMLDocumentFragment retrieveDocumentFragment(NamespaceContext namespaceContext, Node contextNode, String xpathExpression) throws RepositoryOperationException;
    
    
    /**
     * Returns the meta-data associated with this document
     * 
     * @return The meta-data of this document
     */
    public ISMLMetadata getMetadata();     
}
