/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.resource;

import org.w3c.dom.NodeList;

/**
 * Represents a fragment of an SML document
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface ISMLDocumentFragment
{
	/**
	 * Returns the parent document that owns this fragment
	 * 
	 * @return The parent SML document
	 */
    public ISMLDocument getParentDocument();    
    
    
    /**
     * The node list representing a fragment of the parent 
     * SML document
     *  
     * @return A node list representing a fragment of the SML document
     */
    public NodeList getNodeList();
}
