/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.resource;

/**
 * An SML-IF identity is used to retrieve the fields that are included
 * under the SML-IF identity section
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface ISMLIFIdentity
{
	/**
	 * Retrieves the ID of the SML-IF document, which is implementation
	 * specific.
	 * 
	 * @return The id
	 */
	public String getId();
	
	
	/**
	 * Returns the name of the SML-IF document
	 * 
	 * @return The name of the SML-IF document
	 */
    public String getName();
    
    
    /**
     * Returns the version of the SML-IF document
     * 
     * @return The version of the SML-IF document
     */
    public String getVersion();
    
    
    /**
     * Returns the display name of the SML-IF document
     * 
     * @return The display name
     */
    public String getDisplayName();
    
    
    /**
     * Returns the base URI of the SML-IF document
     * 
     * @return The base URI of the SML-IF document
     */
    public String getBaseURI();
    
    
    /**
     * Returns the description of the SML-IF document
     * 
     * @return The description of the SML-IF document
     */
    public String getDescription(); 
}
