/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.repository.resource;

import java.util.List;
import java.util.Map;

/**
 * Represents the meta information of an SML document
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface ISMLMetadata
{
	/**
	 * Indicates an unknown document type
	 */
	public static final int DOCUMENT_TYPE_NONE = -1;
	
	/**
	 * Represents the definition document type
	 */
    public static final int DOCUMENT_TYPE_DEFINITION = 0;
    
    /**
     * Represents the instance document type
     */
    public static final int DOCUMENT_TYPE_INSTANCE = 1;
    
    
    /**
     * Returns the document type
     * 
     * @return {@link #DOCUMENT_TYPE_DEFINITION} if the associated document is of type
     * definition or {@link #DOCUMENT_TYPE_INSTANCE} if the associated document is of type
     * instance.
     */
    public int getDocumentType();

    
    /**
     * Retrieves and returns the id of the associated SML document.  
     * The id is implementation specific.
     * 
     * @return The id of the associated SML document
     */
    public String getId();
    
    
    /**
     * Retrieves and returns the root element name of the associated SML
     * document. 
     * 
     * @return The qualified root element name of the associated SML document
     */
    public String getRootElementName();
    
 
    /**
     * Retrieves and returns the aliases of the associated SML document
     * 
     * @return The aliases of the associated SML document
     */
    public String[] getAliases();
    
    
    /**
     * Retrieves and returns the bound rules of the associated SML document
     * The returned map is expected to be indexed based on the alias that
     * the rule is bound to
     * 
     * @return The bound rules of the associated SML document.
     */
    public Map<String, List<String>> getBoundRules();
    
}
