/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mdr.registration.common.internal;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.dc.mdr.registration.common.internal.SerializerUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MDRIdentifierSerializer {
    private static MDRIdentifierSerializer instance;

    public static MDRIdentifierSerializer getInstance() {
        if (instance == null) {
            instance = new MDRIdentifierSerializer();
        }
        return instance;
    }

    private MDRIdentifierSerializer() {
    }

    public Element toXML(EndpointReference[] mdrIds) {
        Element rootNode = XmlUtils.createElement((QName)new QName("mdrIDs"));
        Document document = rootNode.getOwnerDocument();
        int i = 0;
        while (i < mdrIds.length) {
            Element entry = XmlUtils.createElement((QName)new QName("mdrEntry"));
            Attr attribute = document.createAttribute("id");
            attribute.setValue(mdrIds[i].getAddress().toString());
            entry.setAttributeNode(attribute);
            rootNode.appendChild(entry);
            ++i;
        }
        return rootNode;
    }

    public String[] fromXML(Element mdrIds) {
        Element rootNode = SerializerUtil.findNode(mdrIds, "mdrIDs");
        if (rootNode == null) {
            return new String[0];
        }
        NodeList children = rootNode.getChildNodes();
        ArrayList<String> mdrIdsList = new ArrayList<String>();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if ("mdrEntry".equals(child.getLocalName())) {
                mdrIdsList.add(child.getAttributes().getNamedItem("id").getNodeValue());
            }
            ++i;
        }
        return mdrIdsList.toArray(new String[mdrIdsList.size()]);
    }
}

