/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.management.common;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.management.IntrospectionException;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.me.management.annotations.ComposableManagedCapabilitySet;
import org.eclipse.cosmos.me.management.annotations.CreateManagedRelation;
import org.eclipse.cosmos.me.management.annotations.DestroyManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedEvent;
import org.eclipse.cosmos.me.management.annotations.ManagedEventConsumer;
import org.eclipse.cosmos.me.management.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.me.management.annotations.ManagedOperation;
import org.eclipse.cosmos.me.management.annotations.ManagedProperty;
import org.eclipse.cosmos.me.management.annotations.ManagedPropertyGetter;
import org.eclipse.cosmos.me.management.annotations.ManagedPropertySetter;
import org.eclipse.cosmos.me.management.annotations.ManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedResource;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceFactory;
import org.eclipse.cosmos.me.management.common.ContributionManager;
import org.eclipse.cosmos.me.management.common.IBindingListener;
import org.eclipse.cosmos.me.management.common.info.ComposedCapabilityInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedAttributeInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedNotificationConsumerInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedNotificationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedOperationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedRelationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.common.util.BindingUtil;
import org.eclipse.cosmos.me.management.common.util.ManagementProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingStructureHelper {
    public static final ManagedAttributeInfo[] EMPTY_ATTR_INFO_ARRAY = new ManagedAttributeInfo[0];
    public static final ManagedOperationInfo[] EMPTY_OPER_INFO_ARRAY = new ManagedOperationInfo[0];
    public static final ManagedRelationInfo[] EMPTY_RELATION_INFO_ARRAY = new ManagedRelationInfo[0];
    public static final ManagedNotificationInfo[] EMPTY_NOTIFICATION_INFO_ARRAY = new ManagedNotificationInfo[0];
    public static final ManagedNotificationConsumerInfo[] EMPTY_NOTIFICATION_CONSUMER_INFO_ARRAY = new ManagedNotificationConsumerInfo[0];
    public static final ComposedCapabilityInfo[] EMPTY_COMPOSED_INFO_ARRAY = new ComposedCapabilityInfo[0];
    public static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    public static final String[] EMPTY_CAPABILITY_ARRAY = new String[0];
    private static WeakHashMap<Class, ManagedResourceInfo> boundClassMap = new WeakHashMap();
    private static HashMap<String, Class> capabilityFactoryMap = new HashMap();
    private static ContributionManager manager;
    private static ArrayList<IBindingListener> listenerList;
    private ArrayList<ManagedAttributeInfo> attrInfoList = new ArrayList();
    private ArrayList<ManagedOperationInfo> operInfoList = new ArrayList();
    private ArrayList<ManagedNotificationInfo> notificationInfoList = new ArrayList();
    private ArrayList<ManagedNotificationConsumerInfo> notificationConsumerInfoList = new ArrayList();
    private ArrayList<ManagedRelationInfo> relationInfoList = new ArrayList();
    private ArrayList<ComposedCapabilityInfo> composedInfoList = new ArrayList();
    private HashMap<String, String> internalCapabilityMap = new HashMap();

    static {
        listenerList = new ArrayList();
    }

    public static synchronized ManagedResourceInfo getResourceInfo(Object resource) {
        Class resourceClass = resource.getClass();
        if (Proxy.isProxyClass(resourceClass) && ManagementProxy.class.isAssignableFrom(resourceClass)) {
            resourceClass = ((ManagementProxy)resource).getProxiedClass();
        }
        return boundClassMap.get(resourceClass);
    }

    public static void setContributionManager(ContributionManager cm) {
        manager = cm;
    }

    protected void processResourceCapability(ManagedResourceCapability capability, Class capabilityClass, ArrayList<ManagedAttributeInfo> attrInfoList, ArrayList<ManagedOperationInfo> operInfoList, ArrayList<ManagedRelationInfo> relationInfoList, ArrayList<ManagedNotificationInfo> notificationInfoList, ArrayList<ManagedNotificationConsumerInfo> notificationConsumerInfoList) {
        String ownerNamespace = capability.namespace();
        Method[] methods = capabilityClass.getMethods();
        HashMap<QName, Method> propsGetterMap = new HashMap<QName, Method>();
        HashMap<QName, Method> propsSetterMap = new HashMap<QName, Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            QName propName;
            String namespace;
            Method method = methodArray[n2];
            ManagedOperation operation_annotation = (ManagedOperation)BindingUtil.getMethodAnnotation(ManagedOperation.class, method);
            CreateManagedRelation create_annotation = (CreateManagedRelation)BindingUtil.getMethodAnnotation(CreateManagedRelation.class, method);
            DestroyManagedRelation destroy_annotation = (DestroyManagedRelation)BindingUtil.getMethodAnnotation(DestroyManagedRelation.class, method);
            ManagedEvent event_annotation = (ManagedEvent)BindingUtil.getMethodAnnotation(ManagedEvent.class, method);
            ManagedEventConsumer event_consumer = (ManagedEventConsumer)BindingUtil.getMethodAnnotation(ManagedEventConsumer.class, method);
            ManagedPropertyGetter prop_getter_annotation = (ManagedPropertyGetter)BindingUtil.getMethodAnnotation(ManagedPropertyGetter.class, method);
            ManagedPropertySetter prop_setter_annotation = (ManagedPropertySetter)BindingUtil.getMethodAnnotation(ManagedPropertySetter.class, method);
            String capabilityURI = null;
            ManagedOperationInfo operation = null;
            if (operation_annotation != null) {
                operation = BindingStructureHelper.processOperation(operation_annotation, method);
                operInfoList.add(operation);
            } else if (create_annotation != null) {
                relationInfoList.add(this.processRelation(create_annotation, method));
            } else if (destroy_annotation != null) {
                relationInfoList.add(this.processRelation(destroy_annotation, method));
            } else if (event_consumer != null) {
                operation = BindingStructureHelper.processOperation(event_consumer, method);
                operInfoList.add(operation);
            } else if (prop_getter_annotation != null) {
                namespace = prop_getter_annotation.namespace();
                if ("".equals(namespace)) {
                    namespace = capability.namespace();
                }
                propName = new QName(namespace, prop_getter_annotation.property());
                propsGetterMap.put(propName, method);
            } else if (prop_setter_annotation != null) {
                namespace = prop_setter_annotation.namespace();
                if ("".equals(namespace)) {
                    namespace = capability.namespace();
                }
                propName = new QName(namespace, prop_setter_annotation.property());
                propsSetterMap.put(propName, method);
            }
            if (event_annotation != null) {
                ManagedNotificationInfo notification = BindingStructureHelper.processNotification(event_annotation, method, capabilityClass);
                if (capabilityURI != null) {
                    notification.setSpecCapabilityURI(capabilityURI);
                }
                notificationInfoList.add(notification);
            } else if (event_consumer != null && operation != null) {
                ManagedNotificationConsumerInfo consumer = BindingStructureHelper.processNotificationConsumer(event_consumer, method, capabilityClass, operation);
                if (capabilityURI != null) {
                    consumer.setSpecCapabilityURI(capabilityURI);
                }
                notificationConsumerInfoList.add(consumer);
            }
            ++n2;
        }
        if (!propsGetterMap.isEmpty()) {
            QName[] propNames;
            QName[] qNameArray = propNames = propsGetterMap.keySet().toArray(new QName[0]);
            int n3 = propNames.length;
            n = 0;
            while (n < n3) {
                QName propName = qNameArray[n];
                Method getter = (Method)propsGetterMap.remove(propName);
                Method setter = (Method)propsSetterMap.remove(propName);
                attrInfoList.add(this.processProperty(propName, ownerNamespace, getter, setter));
                ++n;
            }
        }
    }

    protected ManagedResourceInfo processResource(ManagedResource resource, Class resourceClass) {
        Object notificationInfo;
        Object capability_annotation;
        Class<?>[] ifaces;
        int i;
        String resourceNamespace = resource.namespace();
        if ("".equals(resourceNamespace)) {
            ArrayList<String> namespaceList = new ArrayList<String>();
            StringTokenizer toker = new StringTokenizer(resourceClass.getName(), ".");
            while (toker.hasMoreTokens()) {
                namespaceList.add(toker.nextToken());
            }
            String[] names = namespaceList.toArray(new String[0]);
            StringBuffer namespaceBuffer = new StringBuffer("http:/");
            if (names.length < 2) {
                namespaceBuffer.append("/default");
            } else {
                i = names.length - 2;
                while (i >= 0) {
                    namespaceBuffer.append("/" + names[i]);
                    --i;
                }
            }
            resourceNamespace = namespaceBuffer.toString();
        }
        HashMap<String, Field> map = new HashMap<String, Field>();
        Class workingClass = resourceClass;
        while (workingClass != Object.class) {
            BindingUtil.extractFields(workingClass, map);
            workingClass = workingClass.getSuperclass();
        }
        Class<?>[] classArray = ifaces = resourceClass.getInterfaces();
        int n = ifaces.length;
        i = 0;
        while (i < n) {
            Class<?> iface = classArray[i];
            capability_annotation = (ManagedResourceCapability)BindingUtil.getAnnotation(ManagedResourceCapability.class, iface);
            if (capability_annotation != null) {
                this.internalCapabilityMap.put(capability_annotation.namespace(), capability_annotation.namespace());
            }
            ++i;
        }
        Field[] fields = map.values().toArray(EMPTY_FIELD_ARRAY);
        capability_annotation = fields;
        int n2 = fields.length;
        n = 0;
        while (n < n2) {
            Object field = capability_annotation[n];
            ManagedRelation relation_annotation = ((Field)field).getAnnotation(ManagedRelation.class);
            ManagedProperty property_annotation = ((Field)field).getAnnotation(ManagedProperty.class);
            ManagedEvent event_annotation = ((Field)field).getAnnotation(ManagedEvent.class);
            ((Field)field).getAnnotation(ManagedFrameworkAutowire.class);
            if (relation_annotation != null) {
                this.relationInfoList.add(this.processRelation(relation_annotation, (Field)field));
            } else if (property_annotation != null) {
                this.attrInfoList.add(this.processProperty(property_annotation, (Field)field, resource, resourceClass, resourceNamespace));
            }
            if (event_annotation != null) {
                notificationInfo = BindingStructureHelper.processNotification(event_annotation, (Field)field, resourceClass);
                this.notificationInfoList.add((ManagedNotificationInfo)notificationInfo);
            }
            ++n;
        }
        Method[] methods = resourceClass.getMethods();
        HashMap<QName, Method> propsGetterMap = new HashMap<QName, Method>();
        HashMap<QName, Method> propsSetterMap = new HashMap<QName, Method>();
        HashMap<QName, String> propsCapabilityMap = new HashMap<QName, String>();
        notificationInfo = methods;
        int event_annotation = methods.length;
        int n3 = 0;
        while (n3 < event_annotation) {
            String prevNamespace;
            QName propName;
            String propNamespace;
            String namespace;
            Method method = notificationInfo[n3];
            ManagedOperation operation_annotation = (ManagedOperation)BindingUtil.getMethodAnnotation(ManagedOperation.class, method);
            CreateManagedRelation create_annotation = (CreateManagedRelation)BindingUtil.getMethodAnnotation(CreateManagedRelation.class, method);
            DestroyManagedRelation destroy_annotation = (DestroyManagedRelation)BindingUtil.getMethodAnnotation(DestroyManagedRelation.class, method);
            ManagedEvent event_annotation2 = (ManagedEvent)BindingUtil.getMethodAnnotation(ManagedEvent.class, method);
            ManagedEventConsumer event_consumer = (ManagedEventConsumer)BindingUtil.getMethodAnnotation(ManagedEventConsumer.class, method);
            ManagedPropertyGetter prop_getter_annotation = (ManagedPropertyGetter)BindingUtil.getMethodAnnotation(ManagedPropertyGetter.class, method);
            ManagedPropertySetter prop_setter_annotation = (ManagedPropertySetter)BindingUtil.getMethodAnnotation(ManagedPropertySetter.class, method);
            ManagedResourceCapability capability_annotation2 = (ManagedResourceCapability)BindingUtil.getMethodAnnotation(ManagedResourceCapability.class, method);
            ManagedOperationInfo operation = null;
            String capabilityURI = null;
            if (operation_annotation != null) {
                operation = BindingStructureHelper.processOperation(operation_annotation, method);
                this.operInfoList.add(operation);
            } else if (create_annotation != null) {
                this.relationInfoList.add(this.processRelation(create_annotation, method));
            } else if (destroy_annotation != null) {
                this.relationInfoList.add(this.processRelation(destroy_annotation, method));
            } else if (event_consumer != null) {
                operation = BindingStructureHelper.processOperation(event_consumer, method);
                this.operInfoList.add(operation);
            } else if (prop_getter_annotation != null) {
                namespace = "";
                propNamespace = resourceNamespace;
                namespace = prop_getter_annotation.namespace();
                if (capability_annotation2 != null) {
                    propNamespace = capability_annotation2.namespace();
                    if ("".equals(namespace)) {
                        namespace = propNamespace;
                    }
                }
                propName = new QName(namespace, prop_getter_annotation.property());
                propsGetterMap.put(propName, method);
                prevNamespace = (String)propsCapabilityMap.get(propName);
                if (prevNamespace != null && !namespace.equals(prevNamespace)) {
                    this.notifyListener(2, "PropertyNamespaceMismatch", new Object[]{propName});
                } else {
                    propsCapabilityMap.put(propName, propNamespace);
                }
            } else if (prop_setter_annotation != null) {
                namespace = "";
                propNamespace = resourceNamespace;
                namespace = prop_setter_annotation.namespace();
                if (capability_annotation2 != null) {
                    propNamespace = capability_annotation2.namespace();
                    if ("".equals(namespace)) {
                        namespace = propNamespace;
                    }
                }
                propName = new QName(namespace, prop_setter_annotation.property());
                propsSetterMap.put(propName, method);
                prevNamespace = (String)propsCapabilityMap.get(propName);
                if (prevNamespace != null && !namespace.equals(prevNamespace)) {
                    this.notifyListener(2, "PropertyNamespaceMismatch", new Object[]{propName});
                } else {
                    propsCapabilityMap.put(propName, propNamespace);
                }
            }
            if (event_annotation2 != null) {
                ManagedNotificationInfo notificationInfo2 = BindingStructureHelper.processNotification(event_annotation2, method, resourceClass);
                if (capabilityURI != null) {
                    notificationInfo2.setSpecCapabilityURI(capabilityURI);
                }
                this.notificationInfoList.add(notificationInfo2);
            } else if (event_consumer != null) {
                ManagedNotificationConsumerInfo consumer = BindingStructureHelper.processNotificationConsumer(event_consumer, method, resourceClass, operation);
                if (capabilityURI != null) {
                    consumer.setSpecCapabilityURI(capabilityURI);
                }
                this.notificationConsumerInfoList.add(consumer);
            }
            ++n3;
        }
        if (!propsGetterMap.isEmpty()) {
            for (QName propName : propsGetterMap.keySet()) {
                Method getter = (Method)propsGetterMap.get(propName);
                Method setter = (Method)propsSetterMap.remove(propName);
                this.attrInfoList.add(this.processProperty(propName, (String)propsCapabilityMap.get(propName), getter, setter));
            }
        }
        for (ManagedOperationInfo oper : this.operInfoList) {
            System.out.println("Oper " + oper.getNamespace());
            if ("".equals(oper.getNamespace())) continue;
            this.internalCapabilityMap.put(oper.getNamespace(), oper.getNamespace());
        }
        for (ManagedAttributeInfo attr : this.attrInfoList) {
            System.out.println("Attr " + attr.getOwnerNamespace());
            this.internalCapabilityMap.put(attr.getOwnerNamespace(), attr.getOwnerNamespace());
        }
        return new ManagedResourceInfo(resourceClass, resourceClass.getName(), resource.description(), resourceNamespace, this.internalCapabilityMap.keySet().toArray(EMPTY_CAPABILITY_ARRAY), this.attrInfoList.toArray(EMPTY_ATTR_INFO_ARRAY), null, this.operInfoList.toArray(EMPTY_OPER_INFO_ARRAY), this.relationInfoList.toArray(EMPTY_RELATION_INFO_ARRAY), this.notificationInfoList.toArray(EMPTY_NOTIFICATION_INFO_ARRAY), this.notificationConsumerInfoList.toArray(EMPTY_NOTIFICATION_CONSUMER_INFO_ARRAY), this.composedInfoList.toArray(EMPTY_COMPOSED_INFO_ARRAY), BindingUtil.getAnnotations(resourceClass));
    }

    protected ManagedRelationInfo processRelation(ManagedRelation relation, Field field) {
        return new ManagedRelationInfo(relation, field);
    }

    protected ManagedRelationInfo processRelation(CreateManagedRelation relation, Method method) {
        return new ManagedRelationInfo(method.getAnnotations(), method, true);
    }

    protected ManagedRelationInfo processRelation(DestroyManagedRelation relation, Method method) {
        return new ManagedRelationInfo(method.getAnnotations(), method, false);
    }

    protected ManagedAttributeInfo processProperty(ManagedProperty property, Field field, ManagedResource resource, Class resourceClass, String namespace) {
        String description = property.description();
        String name = field.getName();
        name = name.length() == 1 ? name.toUpperCase() : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1, name.length());
        String getterName = "get" + name;
        String setterName = "set" + name;
        Class[] setterParm = new Class[]{field.getType()};
        Class[] getterParm = new Class[]{};
        Method getterMethod = null;
        Method setterMethod = null;
        try {
            getterMethod = resourceClass.getMethod(getterName, getterParm);
            if (!getterMethod.getReturnType().equals(field.getType())) {
                getterMethod = null;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            setterMethod = resourceClass.getMethod(setterName, setterParm);
            if (!setterMethod.getReturnType().equals(Void.TYPE)) {
                setterMethod = null;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            String ns = property.namespace();
            if ("".equals(ns)) {
                ns = namespace;
            }
            return new ManagedAttributeInfo(field.getName(), ns, namespace, description, getterMethod, setterMethod, field.getAnnotations());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ManagedAttributeInfo processProperty(QName propName, String ownerNamespace, Method getterMethod, Method setterMethod) {
        String description = "";
        Class<?> retType = getterMethod.getReturnType();
        if (setterMethod != null) {
            Class<?>[] parmTypes = setterMethod.getParameterTypes();
            if (parmTypes.length != 1) {
                return null;
            }
            if (!parmTypes[0].equals(retType)) {
                return null;
            }
        }
        try {
            return new ManagedAttributeInfo(propName.getLocalPart(), propName.getNamespaceURI(), ownerNamespace, description, getterMethod, setterMethod, BindingUtil.getAnnotations(getterMethod));
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static ManagedNotificationInfo processNotification(ManagedEvent event, Field field, Class resourceClass) {
        return new ManagedNotificationInfo(new String[0], event.topic(), event.description(), event.namespace(), null);
    }

    protected static ManagedNotificationInfo processNotification(ManagedEvent event, Method method, Class resourceClass) {
        String namespace = event.namespace();
        if ("".equals(event.namespace())) {
            Class<?>[] interfazes;
            Class<?>[] classArray = interfazes = resourceClass.getInterfaces();
            int n = interfazes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaze = classArray[n2];
                ManagedResourceCapability cap = (ManagedResourceCapability)BindingUtil.getAnnotationFromInterface(ManagedResourceCapability.class, interfaze);
                if (cap != null) {
                    Method[] methods;
                    Method[] methodArray = methods = interfaze.getMethods();
                    int n3 = methods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Method imethod = methodArray[n4];
                        if (BindingUtil.equivalentMethod(method, imethod)) {
                            namespace = cap.namespace();
                            break;
                        }
                        ++n4;
                    }
                    if (!"".equals(namespace)) break;
                }
                ++n2;
            }
        }
        return new ManagedNotificationInfo(new String[0], event.topic(), event.description(), namespace, null);
    }

    protected static ManagedNotificationConsumerInfo processNotificationConsumer(ManagedEventConsumer event, Method method, Class resourceClass, ManagedOperationInfo operation) {
        Class<?>[] interfazes;
        String namespace = "";
        Class<?>[] classArray = interfazes = resourceClass.getInterfaces();
        int n = interfazes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            ManagedResourceCapability cap = (ManagedResourceCapability)BindingUtil.getAnnotationFromInterface(ManagedResourceCapability.class, interfaze);
            if (cap != null) {
                Method[] methods;
                Method[] methodArray = methods = interfaze.getMethods();
                int n3 = methods.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method imethod = methodArray[n4];
                    if (BindingUtil.equivalentMethod(method, imethod)) {
                        namespace = cap.namespace();
                        break;
                    }
                    ++n4;
                }
                if (!"".equals(namespace)) break;
            }
            ++n2;
        }
        return new ManagedNotificationConsumerInfo(new String[0], event.topic(), event.description(), namespace, null, operation);
    }

    protected static ManagedOperationInfo processOperation(ManagedOperation operation, Method method) {
        return new ManagedOperationInfo(operation.description(), method, BindingUtil.getAnnotations(method), BindingUtil.getParameterAnnotations(method));
    }

    protected static ManagedOperationInfo processOperation(ManagedEventConsumer consumer, Method method) {
        return new ManagedOperationInfo("event consumer", method, BindingUtil.getAnnotations(method), BindingUtil.getParameterAnnotations(method));
    }

    public ManagedResourceInfo register(Object resource) throws Exception {
        ManagedResourceInfo managedInfo;
        Class resourceClass = resource.getClass();
        if (Proxy.isProxyClass(resourceClass) && ManagementProxy.class.isAssignableFrom(resourceClass)) {
            resourceClass = ((ManagementProxy)resource).getProxiedClass();
        }
        if ((managedInfo = boundClassMap.get(resourceClass)) == null) {
            ManagedResource resource_annotation = (ManagedResource)BindingUtil.getAnnotation(ManagedResource.class, resourceClass);
            if (resource_annotation == null) {
                throw new Exception("Invalid Resource - does not contain ManagedResource annotation: " + resource.getClass().getName());
            }
            ComposableManagedCapabilitySet compositionSet = (ComposableManagedCapabilitySet)BindingUtil.getAnnotation(ComposableManagedCapabilitySet.class, resourceClass);
            if (compositionSet != null) {
                Class[] compositionTargets;
                Class[] classArray = compositionTargets = compositionSet.set();
                int n = compositionTargets.length;
                int n2 = 0;
                while (n2 < n) {
                    Class target = classArray[n2];
                    ManagedResourceCapability cap = (ManagedResourceCapability)BindingUtil.getAnnotation(ManagedResourceCapability.class, target);
                    if (cap == null) {
                        throw new Exception("Unable to Bind - invalid composition");
                    }
                    ManagedResourceFactory cfr_ignored_0 = (ManagedResourceFactory)BindingUtil.getAnnotation(ManagedResourceFactory.class, target);
                    this.processResourceCapability(cap, target, this.attrInfoList, this.operInfoList, this.relationInfoList, this.notificationInfoList, this.notificationConsumerInfoList);
                    this.composedInfoList.add(new ComposedCapabilityInfo(cap, target));
                    ++n2;
                }
            }
            managedInfo = this.processResource(resource_annotation, resourceClass);
            boundClassMap.put(resourceClass, managedInfo);
        }
        return managedInfo;
    }

    public static void processAutowire(Object resource, ManagedFrameworkAutowire autowire, Field field, Class<? extends Object> targetClass, Object target, ComposedCapabilityInfo[] composedInfoList, HashMap<String, Object> capImplMap) {
        String name = field.getName();
        name = name.length() == 1 ? name.toUpperCase() : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1, name.length());
        String setterName = "set" + name;
        Class[] setterParm = new Class[]{field.getType()};
        Method setterMethod = null;
        Object autowireTarget = null;
        if (autowire.capability() != Void.class) {
            ComposedCapabilityInfo[] composedCapabilityInfoArray = composedInfoList;
            int n = composedInfoList.length;
            int n2 = 0;
            while (n2 < n) {
                ComposedCapabilityInfo info = composedCapabilityInfoArray[n2];
                if (info.getImplClass().equals(autowire.capability())) {
                    autowireTarget = capImplMap.get(info.getNamespace());
                    break;
                }
                ++n2;
            }
        } else {
            autowireTarget = "$RESOURCE".equals(autowire.name()) ? resource : manager.getAutowireTarget(autowire.name());
        }
        if (autowireTarget != null && field.getType().isAssignableFrom(autowireTarget.getClass())) {
            try {
                setterMethod = targetClass.getMethod(setterName, setterParm);
                if (!setterMethod.getReturnType().equals(Void.TYPE)) {
                    setterMethod = null;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                if (setterMethod != null) {
                    Object impl = target;
                    if (target instanceof ManagementProxy) {
                        impl = ((ManagementProxy)target).getProxiedObject();
                    }
                    setterMethod.invoke(impl, autowireTarget);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void processAutowire(ManagedResourceInfo info, Object resource, HashMap<String, Object> capImplMap) {
        Class resourceClass;
        ComposedCapabilityInfo[] composedCapabilities = info.getComposedCapabilities();
        HashMap<String, Field> map = new HashMap<String, Field>();
        Class workingClass = resourceClass = info.getResourceClass();
        while (workingClass != Object.class) {
            BindingUtil.extractFields(workingClass, map);
            workingClass = workingClass.getSuperclass();
        }
        Field[] fields = map.values().toArray(EMPTY_FIELD_ARRAY);
        Object[] objectArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = objectArray[n2];
            ManagedFrameworkAutowire autowire = field.getAnnotation(ManagedFrameworkAutowire.class);
            if (autowire != null) {
                BindingStructureHelper.processAutowire(resource, autowire, field, resourceClass, resource, composedCapabilities, capImplMap);
            }
            ++n2;
        }
        objectArray = composedCapabilities;
        n = composedCapabilities.length;
        n2 = 0;
        while (n2 < n) {
            Object capInfo = objectArray[n2];
            workingClass = ((ComposedCapabilityInfo)capInfo).getImplClass();
            while (workingClass != null && workingClass != Object.class) {
                BindingUtil.extractFields(workingClass, map);
                workingClass = workingClass.getSuperclass();
            }
            Field[] fieldArray = fields = map.values().toArray(EMPTY_FIELD_ARRAY);
            int n3 = fields.length;
            int n4 = 0;
            while (n4 < n3) {
                Field field = fieldArray[n4];
                ManagedFrameworkAutowire autowire = field.getAnnotation(ManagedFrameworkAutowire.class);
                if (autowire != null) {
                    BindingStructureHelper.processAutowire(resource, autowire, field, ((ComposedCapabilityInfo)capInfo).getImplClass(), capImplMap.get(((ComposedCapabilityInfo)capInfo).getNamespace()), composedCapabilities, capImplMap);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void setCapabilityFactory(String uri, Class factory) {
        capabilityFactoryMap.put(uri, factory);
    }

    public static Class getCapabilityFactory(String uri) {
        return capabilityFactoryMap.get(uri);
    }

    public static Object instantiateCapability(String uri, Class target) throws Exception {
        ManagedResourceFactory factory = (ManagedResourceFactory)BindingUtil.getAnnotation(ManagedResourceFactory.class, target);
        Object capImpl = null;
        if (factory != null) {
            System.out.println("Using factory");
        } else if (target.isInterface() && capabilityFactoryMap.get(uri) != null) {
            System.out.println("Using default factory");
            Class targetFactory = capabilityFactoryMap.get(uri);
            if (targetFactory != null) {
                try {
                    Method factoryMethod = targetFactory.getMethod("create", new Class[0]);
                    if (factoryMethod != null) {
                        System.out.println(Modifier.isStatic(factoryMethod.getModifiers()));
                        System.out.println(factoryMethod.isAccessible());
                        capImpl = factoryMethod.invoke(null, new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    capImpl = targetFactory.newInstance();
                }
            }
        } else {
            try {
                capImpl = target.newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException("Failed to create Capability instance for " + uri + " Class:" + target.getName());
            }
        }
        return capImpl;
    }

    public static void addListener(IBindingListener listener) {
        listenerList.add(listener);
    }

    public static void removeListener(IBindingListener listener) {
        listenerList.remove(listener);
    }

    private void notifyListener(int serverity, String messageId, Object[] parms) {
        for (IBindingListener listener : listenerList) {
            listener.notify(serverity, messageId, parms);
        }
    }

    private void notifyListener(int serverity, String messageId, Object[] parms, Throwable t) {
        for (IBindingListener listener : listenerList) {
            listener.notify(serverity, messageId, parms, t);
        }
    }
}

